/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.webauthn;

import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.PackedAttestationStatement;
import com.webauthn4j.test.TestDataConstants;
import com.webauthn4j.test.TestDataUtil;
import com.webauthn4j.test.authenticator.webauthn.WebAuthnModelAuthenticator;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import java.security.PrivateKey;

public class PackedAuthenticator
extends WebAuthnModelAuthenticator {
    private PrivateKey attestationPrivateKey = TestDataConstants.GENERIC_3TIER_ATTESTATION_PRIVATE_KEY;
    private AttestationCertificatePath attestationCertificatePath = TestDataConstants.GENERIC_3TIER_ATTESTATION_CERTIFICATE_PATH;

    @Override
    public AttestationStatement generateAttestationStatement(byte[] signedData, RegistrationEmulationOption registrationEmulationOption) {
        byte[] signature = registrationEmulationOption.isSignatureOverrideEnabled() ? registrationEmulationOption.getSignature() : TestDataUtil.calculateSignature(this.attestationPrivateKey, signedData);
        return new PackedAttestationStatement(COSEAlgorithmIdentifier.ES256, signature, this.attestationCertificatePath, null);
    }
}

