/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.client;

import com.webauthn4j.attestation.AttestationObject;
import com.webauthn4j.attestation.statement.AttestationStatement;
import com.webauthn4j.attestation.statement.NoneAttestationStatement;
import com.webauthn4j.client.ClientDataType;
import com.webauthn4j.client.CollectedClientData;
import com.webauthn4j.client.Origin;
import com.webauthn4j.client.TokenBinding;
import com.webauthn4j.client.TokenBindingStatus;
import com.webauthn4j.client.challenge.Challenge;
import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.ClientExtensionOutputsConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.extension.authneticator.AuthenticatorExtensionOutput;
import com.webauthn4j.extension.authneticator.SupportedExtensionsAuthenticatorExtensionOutput;
import com.webauthn4j.extension.client.ClientExtensionOutput;
import com.webauthn4j.extension.client.SupportedExtensionsClientExtensionOutput;
import com.webauthn4j.test.authenticator.AuthenticatorAdaptor;
import com.webauthn4j.test.authenticator.CredentialCreationResponse;
import com.webauthn4j.test.authenticator.CredentialRequestResponse;
import com.webauthn4j.test.authenticator.model.WebAuthnModelAuthenticatorAdaptor;
import com.webauthn4j.test.client.AuthenticationEmulationOption;
import com.webauthn4j.test.client.AuthenticatorAssertionResponse;
import com.webauthn4j.test.client.AuthenticatorAttestationResponse;
import com.webauthn4j.test.client.NoAuthenticatorSuccessException;
import com.webauthn4j.test.client.PublicKeyCredential;
import com.webauthn4j.test.client.PublicKeyCredentialCreationOptions;
import com.webauthn4j.test.client.PublicKeyCredentialRequestOptions;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.WIP;
import com.webauthn4j.util.exception.NotImplementedException;
import com.webauthn4j.validator.exception.ValidationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@WIP
public class ClientPlatform {
    private AttestationObjectConverter attestationObjectConverter = new AttestationObjectConverter();
    private CollectedClientDataConverter collectedClientDataConverter = new CollectedClientDataConverter();
    private ClientExtensionOutputsConverter clientExtensionOutputsConverter = new ClientExtensionOutputsConverter();
    private Origin origin;
    private AuthenticatorAdaptor authenticatorAdaptor;

    public ClientPlatform(Origin origin, AuthenticatorAdaptor authenticatorAdaptor) {
        this.origin = origin;
        this.authenticatorAdaptor = authenticatorAdaptor;
    }

    public ClientPlatform(AuthenticatorAdaptor authenticatorAdaptor) {
        this(new Origin("https://example.com"), authenticatorAdaptor);
    }

    public ClientPlatform(Origin origin) {
        this(origin, new WebAuthnModelAuthenticatorAdaptor());
    }

    public ClientPlatform() {
        this(new Origin("https://example.com"));
    }

    public PublicKeyCredential<AuthenticatorAttestationResponse> create(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, RegistrationEmulationOption registrationEmulationOption) {
        CollectedClientData collectedClientData = registrationEmulationOption.isCollectedClientDataOverrideEnabled() ? registrationEmulationOption.getCollectedClientData() : this.createCollectedClientData(ClientDataType.CREATE, publicKeyCredentialCreationOptions.getChallenge());
        if (this.authenticatorAdaptor == null) {
            throw new NoAuthenticatorSuccessException();
        }
        CredentialCreationResponse credentialCreationResponse = this.authenticatorAdaptor.register(publicKeyCredentialCreationOptions, collectedClientData, registrationEmulationOption);
        AttestationObject attestationObject = credentialCreationResponse.getAttestationObject();
        AttestationStatement attestationStatement = credentialCreationResponse.getAttestationObject().getAttestationStatement();
        switch (publicKeyCredentialCreationOptions.getAttestation()) {
            case DIRECT: {
                break;
            }
            case INDIRECT: {
                throw new NotImplementedException();
            }
            case NONE: {
                attestationStatement = new NoneAttestationStatement();
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        attestationObject = new AttestationObject(attestationObject.getAuthenticatorData(), attestationStatement);
        byte[] attestationObjectBytes = this.attestationObjectConverter.convertToBytes(attestationObject);
        byte[] credentialId = credentialCreationResponse.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getCredentialId();
        byte[] collectedClientDataBytes = this.collectedClientDataConverter.convertToBytes(collectedClientData);
        Map<String, ClientExtensionOutput> clientExtensions = this.convertExtensions(credentialCreationResponse.getAttestationObject().getAuthenticatorData().getExtensions());
        String clientExtensionsJSON = this.clientExtensionOutputsConverter.convertToString(clientExtensions);
        return new PublicKeyCredential<AuthenticatorAttestationResponse>(credentialId, new AuthenticatorAttestationResponse(collectedClientDataBytes, attestationObjectBytes, clientExtensionsJSON));
    }

    private Map<String, ClientExtensionOutput> convertExtensions(Map<String, AuthenticatorExtensionOutput> extensions) {
        HashMap<String, ClientExtensionOutput> map = new HashMap<String, ClientExtensionOutput>();
        extensions.forEach((key, value) -> {
            if (key.equals("exts")) {
                SupportedExtensionsAuthenticatorExtensionOutput authenticatorExtensionOutput = (SupportedExtensionsAuthenticatorExtensionOutput)value;
                map.put((String)key, (ClientExtensionOutput)new SupportedExtensionsClientExtensionOutput((List)authenticatorExtensionOutput.getValue()));
            }
        });
        return map;
    }

    public PublicKeyCredential<AuthenticatorAttestationResponse> create(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions) {
        return this.create(publicKeyCredentialCreationOptions, new RegistrationEmulationOption());
    }

    public PublicKeyCredential<AuthenticatorAssertionResponse> get(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData, AuthenticationEmulationOption authenticationEmulationOption) {
        NoAuthenticatorSuccessException noAuthenticatorSuccessException = new NoAuthenticatorSuccessException();
        if (this.authenticatorAdaptor == null) {
            throw noAuthenticatorSuccessException;
        }
        try {
            CredentialRequestResponse credentialRequestResponse = this.authenticatorAdaptor.authenticate(publicKeyCredentialRequestOptions, collectedClientData, authenticationEmulationOption);
            byte[] credentialId = credentialRequestResponse.getCredentialId();
            return new PublicKeyCredential<AuthenticatorAssertionResponse>(credentialId, new AuthenticatorAssertionResponse(credentialRequestResponse.getCollectedClientDataBytes(), credentialRequestResponse.getAuthenticatorDataBytes(), credentialRequestResponse.getSignature(), credentialRequestResponse.getUserHandle()));
        }
        catch (ValidationException e) {
            noAuthenticatorSuccessException.addSuppressed(e);
            throw noAuthenticatorSuccessException;
        }
    }

    public PublicKeyCredential<AuthenticatorAssertionResponse> get(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData) {
        return this.get(publicKeyCredentialRequestOptions, collectedClientData, new AuthenticationEmulationOption());
    }

    public PublicKeyCredential<AuthenticatorAssertionResponse> get(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) {
        CollectedClientData collectedClientData = this.createCollectedClientData(ClientDataType.GET, publicKeyCredentialRequestOptions.getChallenge());
        return this.get(publicKeyCredentialRequestOptions, collectedClientData);
    }

    public CollectedClientData createCollectedClientData(ClientDataType type, Challenge challenge) {
        return new CollectedClientData(type, challenge, this.origin, null);
    }

    public CollectedClientData createCollectedClientData(ClientDataType type, Challenge challenge, byte[] tokenBindingId) {
        TokenBinding tokenBinding = new TokenBinding(TokenBindingStatus.PRESENT, tokenBindingId);
        return new CollectedClientData(type, challenge, this.origin, tokenBinding);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public AuthenticatorAdaptor getAuthenticatorAdaptor() {
        return this.authenticatorAdaptor;
    }

    public void setAuthenticatorAdaptor(AuthenticatorAdaptor authenticatorAdaptor) {
        this.authenticatorAdaptor = authenticatorAdaptor;
    }
}

