/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.webauthn;

import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.PublicKeyCredentialDescriptor;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.PublicKeyCredentialRpEntity;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.authenticator.EC2COSEKey;
import com.webauthn4j.data.attestation.authenticator.RSACOSEKey;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.test.CACertificatePath;
import com.webauthn4j.test.CipherUtil;
import com.webauthn4j.test.TestAttestationUtil;
import com.webauthn4j.test.TestDataUtil;
import com.webauthn4j.test.authenticator.webauthn.AttestationOption;
import com.webauthn4j.test.authenticator.webauthn.AttestationStatementRequest;
import com.webauthn4j.test.authenticator.webauthn.CredentialMapKey;
import com.webauthn4j.test.authenticator.webauthn.GetAssertionRequest;
import com.webauthn4j.test.authenticator.webauthn.GetAssertionResponse;
import com.webauthn4j.test.authenticator.webauthn.MakeCredentialRequest;
import com.webauthn4j.test.authenticator.webauthn.MakeCredentialResponse;
import com.webauthn4j.test.authenticator.webauthn.PublicKeyCredentialSource;
import com.webauthn4j.test.authenticator.webauthn.WebAuthnAuthenticator;
import com.webauthn4j.test.authenticator.webauthn.exception.ConstraintException;
import com.webauthn4j.test.authenticator.webauthn.exception.InvalidStateException;
import com.webauthn4j.test.authenticator.webauthn.exception.NotAllowedException;
import com.webauthn4j.test.authenticator.webauthn.exception.NotSupportedException;
import com.webauthn4j.test.authenticator.webauthn.exception.WebAuthnModelException;
import com.webauthn4j.test.client.AuthenticationEmulationOption;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.ECUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.util.RSAUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import tools.jackson.dataformat.cbor.CBORMapper;

public abstract class WebAuthnModelAuthenticator
implements WebAuthnAuthenticator {
    private static final SecureRandom secureRandom = new SecureRandom();
    protected final ObjectConverter objectConverter;
    private final CBORMapper cborMapper;
    private final AAGUID aaguid;
    private final KeyPair attestationKeyPair;
    private final CACertificatePath caCertificatePath;
    private final PrivateKey attestationIssuerPrivateKey;
    private final Map<CredentialMapKey, PublicKeyCredentialSource> credentialMap;
    private final boolean capableOfUserVerification;
    private final AuthenticatorDataConverter authenticatorDataConverter;
    private final byte[] credentialEncryptionKey;
    private int counter;
    private boolean countUpEnabled = true;

    public WebAuthnModelAuthenticator(AAGUID aaguid, KeyPair attestationKeyPair, CACertificatePath caCertificatePath, PrivateKey attestationIssuerPrivateKey, int counter, boolean capableOfUserVerification, ObjectConverter objectConverter) {
        this.aaguid = aaguid;
        this.attestationKeyPair = attestationKeyPair;
        this.caCertificatePath = caCertificatePath;
        this.attestationIssuerPrivateKey = attestationIssuerPrivateKey;
        this.credentialMap = new HashMap<CredentialMapKey, PublicKeyCredentialSource>();
        this.counter = counter;
        this.capableOfUserVerification = capableOfUserVerification;
        this.objectConverter = objectConverter;
        this.cborMapper = objectConverter.getCborMapper();
        this.authenticatorDataConverter = new AuthenticatorDataConverter(objectConverter);
        this.credentialEncryptionKey = new byte[32];
        secureRandom.nextBytes(this.credentialEncryptionKey);
    }

    public WebAuthnModelAuthenticator() {
        this(AAGUID.ZERO, new KeyPair(TestAttestationUtil.load3tierTestAuthenticatorAttestationPublicKey(), TestAttestationUtil.load3tierTestAuthenticatorAttestationPrivateKey()), TestAttestationUtil.load3tierTestCACertificatePath(), TestAttestationUtil.load3tierTestIntermediateCAPrivateKey(), 0, true, new ObjectConverter());
    }

    public PublicKeyCredentialSource lookup(byte[] credentialId) {
        if (this.isCapableOfStoringClientSideResidentCredential()) {
            for (Map.Entry<CredentialMapKey, PublicKeyCredentialSource> entry : this.credentialMap.entrySet()) {
                if (!Arrays.equals(credentialId, entry.getValue().getId())) continue;
                return entry.getValue();
            }
        }
        try {
            byte[] cbor = CipherUtil.decrypt(credentialId, this.credentialEncryptionKey);
            PublicKeyCredentialSource src = (PublicKeyCredentialSource)this.cborMapper.readValue(cbor, PublicKeyCredentialSource.class);
            src.setId(credentialId);
            return src;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public MakeCredentialResponse makeCredential(MakeCredentialRequest makeCredentialRequest, RegistrationEmulationOption registrationEmulationOption) {
        byte[] credentialId;
        EC2COSEKey coseKeyPair;
        EC2COSEKey cosePublicKey;
        PublicKeyCredentialRpEntity rpEntity = makeCredentialRequest.getRpEntity();
        Optional<PublicKeyCredentialParameters> optionalPublicKeyCredentialParameters = makeCredentialRequest.getCredTypesAndPublicKeyAlgs().stream().filter(this::isCapableOfHandling).findFirst();
        if (!optionalPublicKeyCredentialParameters.isPresent()) {
            throw new NotSupportedException("Specified PublicKeyCredentialParameters are not supported");
        }
        PublicKeyCredentialParameters publicKeyCredentialParameters = optionalPublicKeyCredentialParameters.get();
        List<Object> descriptors = makeCredentialRequest.getExcludeCredentialDescriptorList();
        if (descriptors == null) {
            descriptors = Collections.emptyList();
        }
        for (PublicKeyCredentialDescriptor descriptor : descriptors) {
            PublicKeyCredentialSource publicKeyCredentialSource = this.lookup(descriptor.getId());
            if (publicKeyCredentialSource == null || !publicKeyCredentialSource.getRpId().equals(rpEntity.getId()) || !publicKeyCredentialSource.getType().equals((Object)descriptor.getType())) continue;
            boolean userConsent = true;
            if (userConsent) {
                throw new InvalidStateException("");
            }
            throw new NotAllowedException("User consent is required");
        }
        if (makeCredentialRequest.isRequireResidentKey() && !this.isCapableOfStoringClientSideResidentCredential()) {
            throw new ConstraintException("Authenticator isn't capable of storing client-side resident credential");
        }
        if (makeCredentialRequest.isRequireUserVerification() && !this.isCapableOfUserVerification()) {
            throw new ConstraintException("Authenticator isn't capable of user verification");
        }
        boolean userVerification = true;
        boolean userConsent = true;
        if (makeCredentialRequest.isRequireUserVerification() && !userVerification) {
            throw new NotAllowedException("User is not verified.");
        }
        if (makeCredentialRequest.isRequireUserPresence() && !userConsent) {
            throw new NotAllowedException("User doesn't resolve consent.");
        }
        COSEAlgorithmIdentifier alg = publicKeyCredentialParameters.getAlg();
        try {
            EC2COSEKey cosePrivateKey;
            if (Arrays.asList(COSEAlgorithmIdentifier.ES256, COSEAlgorithmIdentifier.ES384, COSEAlgorithmIdentifier.ES512).contains(alg)) {
                KeyPair credentialKeyPair = ECUtil.createKeyPair();
                publicKey = (ECPublicKey)credentialKeyPair.getPublic();
                privateKey = (ECPrivateKey)credentialKeyPair.getPrivate();
                cosePublicKey = TestDataUtil.createEC2COSEPublicKey(publicKey);
                cosePrivateKey = TestDataUtil.createEC2COSEPrivateKey(publicKey, privateKey);
                coseKeyPair = EC2COSEKey.create((KeyPair)credentialKeyPair, (COSEAlgorithmIdentifier)alg);
            } else if (Arrays.asList(COSEAlgorithmIdentifier.RS256, COSEAlgorithmIdentifier.RS384, COSEAlgorithmIdentifier.RS512, COSEAlgorithmIdentifier.PS256, COSEAlgorithmIdentifier.PS384, COSEAlgorithmIdentifier.PS512).contains(alg)) {
                KeyPair credentialKeyPair = RSAUtil.createKeyPair();
                publicKey = (RSAPublicKey)credentialKeyPair.getPublic();
                privateKey = (RSAPrivateKey)credentialKeyPair.getPrivate();
                cosePublicKey = RSACOSEKey.create((RSAPublicKey)publicKey, (COSEAlgorithmIdentifier)alg);
                cosePrivateKey = RSACOSEKey.create((RSAPrivateKey)privateKey, (COSEAlgorithmIdentifier)alg);
                coseKeyPair = RSACOSEKey.create((KeyPair)credentialKeyPair, (COSEAlgorithmIdentifier)alg);
            } else {
                throw new NotSupportedException("Specified alg are not supported");
            }
            byte[] userHandle = makeCredentialRequest.getUserEntity().getId();
            PublicKeyCredentialSource credentialSource = new PublicKeyCredentialSource();
            credentialSource.setType(PublicKeyCredentialType.PUBLIC_KEY);
            credentialSource.setPrivateKey((COSEKey)cosePrivateKey);
            credentialSource.setRpId(rpEntity.getId());
            credentialSource.setUserHandle(userHandle);
            credentialSource.setOtherUI(null);
            if (makeCredentialRequest.isRequireResidentKey()) {
                credentialId = new byte[32];
                secureRandom.nextBytes(credentialId);
                credentialSource.setId(credentialId);
                Map<CredentialMapKey, PublicKeyCredentialSource> credentials = this.credentialMap;
                credentials.put(new CredentialMapKey(rpEntity.getId(), userHandle), credentialSource);
            } else {
                byte[] data = this.cborMapper.writeValueAsBytes((Object)credentialSource);
                credentialId = CipherUtil.encrypt(data, this.credentialEncryptionKey);
            }
        }
        catch (RuntimeException e) {
            throw new WebAuthnModelException(e);
        }
        AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> registrationExtensionAuthenticatorOutputs = this.processRegistrationExtensions(makeCredentialRequest);
        this.countUp();
        byte[] rpIdHash = MessageDigestUtil.createSHA256().digest(rpEntity.getId().getBytes(StandardCharsets.UTF_8));
        byte flag = 64;
        if (userConsent) {
            flag = (byte)(flag | 1);
        }
        if (userVerification) {
            flag = (byte)(flag | 4);
        }
        if (!registrationExtensionAuthenticatorOutputs.getKeys().isEmpty()) {
            flag = (byte)(flag | 0xFFFFFF80);
        }
        AttestedCredentialData attestedCredentialData = new AttestedCredentialData(this.aaguid, credentialId, (COSEKey)cosePublicKey);
        AuthenticatorData authenticatorData = new AuthenticatorData(rpIdHash, flag, (long)this.counter, attestedCredentialData, registrationExtensionAuthenticatorOutputs);
        byte[] authenticatorDataBytes = this.authenticatorDataConverter.convert(authenticatorData);
        byte[] signedData = this.getSignedData(authenticatorDataBytes, makeCredentialRequest.getHash());
        byte[] clientDataHash = makeCredentialRequest.getHash();
        AttestationStatementRequest attestationStatementRequest = new AttestationStatementRequest(signedData, (COSEKey)coseKeyPair, clientDataHash);
        AttestationStatement attestationStatement = this.createAttestationStatement(attestationStatementRequest, registrationEmulationOption);
        AttestationObject attestationObject = new AttestationObject(authenticatorData, attestationStatement);
        MakeCredentialResponse makeCredentialResponse = new MakeCredentialResponse();
        makeCredentialResponse.setAttestationObject(attestationObject);
        return makeCredentialResponse;
    }

    private AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> processRegistrationExtensions(MakeCredentialRequest makeCredentialRequest) {
        AuthenticationExtensionsClientInputs extensions = makeCredentialRequest.getExtensions();
        if (extensions == null) {
            extensions = new AuthenticationExtensionsClientInputs();
        }
        AuthenticationExtensionsAuthenticatorOutputs.BuilderForRegistration builder = new AuthenticationExtensionsAuthenticatorOutputs.BuilderForRegistration();
        for (String string : extensions.getKeys()) {
        }
        return builder.build();
    }

    public MakeCredentialResponse makeCredential(MakeCredentialRequest makeCredentialRequest) {
        return this.makeCredential(makeCredentialRequest, new RegistrationEmulationOption());
    }

    @Override
    public GetAssertionResponse getAssertion(GetAssertionRequest getAssertionRequest, AuthenticationEmulationOption authenticationEmulationOption) {
        byte flags = 0;
        List<Object> credentialOptions = new ArrayList<PublicKeyCredentialSource>();
        List<PublicKeyCredentialDescriptor> allowCredentialDescriptorList = getAssertionRequest.getAllowCredentialDescriptorList();
        if (allowCredentialDescriptorList != null && !allowCredentialDescriptorList.isEmpty()) {
            for (PublicKeyCredentialDescriptor credentialDescriptor : getAssertionRequest.getAllowCredentialDescriptorList()) {
                PublicKeyCredentialSource credSource = this.lookup(credentialDescriptor.getId());
                if (credSource == null) continue;
                credentialOptions.add(credSource);
            }
        } else {
            for (Map.Entry<CredentialMapKey, PublicKeyCredentialSource> entry : this.credentialMap.entrySet()) {
                credentialOptions.add(entry.getValue());
            }
        }
        if ((credentialOptions = credentialOptions.stream().filter(item -> item.getRpId().equals(getAssertionRequest.getRpId())).collect(Collectors.toList())).isEmpty()) {
            throw new NotAllowedException("No matching authenticator found");
        }
        if (getAssertionRequest.isRequireUserVerification()) {
            flags = (byte)(flags | 4);
        }
        if (getAssertionRequest.isRequireUserPresence()) {
            flags = (byte)(flags | 1);
        }
        PublicKeyCredentialSource selectedCredential = (PublicKeyCredentialSource)credentialOptions.get(0);
        AuthenticationExtensionsAuthenticatorOutputs processedExtensions = new AuthenticationExtensionsAuthenticatorOutputs();
        if (!processedExtensions.getKeys().isEmpty()) {
            flags = (byte)(flags | 0xFFFFFF80);
        }
        this.countUp();
        byte[] rpIdHash = MessageDigestUtil.createSHA256().digest(getAssertionRequest.getRpId().getBytes(StandardCharsets.UTF_8));
        AuthenticatorData authenticatorDataObject = new AuthenticatorData(rpIdHash, flags, (long)this.counter, processedExtensions);
        byte[] authenticatorData = this.authenticatorDataConverter.convert(authenticatorDataObject);
        byte[] clientDataHash = getAssertionRequest.getHash();
        byte[] signedData = ByteBuffer.allocate(authenticatorData.length + clientDataHash.length).put(authenticatorData).put(clientDataHash).array();
        byte[] signature = TestDataUtil.calculateSignature(selectedCredential.getPrivateKey(), signedData);
        GetAssertionResponse getAssertionResponse = new GetAssertionResponse();
        getAssertionResponse.setCredentialId(selectedCredential.getId());
        getAssertionResponse.setAuthenticatorData(authenticatorData);
        getAssertionResponse.setSignature(signature);
        getAssertionResponse.setUserHandle(selectedCredential.getUserHandle());
        return getAssertionResponse;
    }

    public GetAssertionResponse getAssertion(GetAssertionRequest getAssertionRequest) {
        return this.getAssertion(getAssertionRequest, new AuthenticationEmulationOption());
    }

    @Override
    public boolean isCapableOfUserVerification() {
        return this.capableOfUserVerification;
    }

    @Override
    public boolean isCapableOfStoringClientSideResidentCredential() {
        return true;
    }

    private boolean isCapableOfHandling(PublicKeyCredentialParameters publicKeyCredentialParameters) {
        return publicKeyCredentialParameters.getType().equals((Object)PublicKeyCredentialType.PUBLIC_KEY) && (COSEAlgorithmIdentifier.ES256.equals((Object)publicKeyCredentialParameters.getAlg()) || COSEAlgorithmIdentifier.PS256.equals((Object)publicKeyCredentialParameters.getAlg()));
    }

    @Override
    public boolean isCountUpEnabled() {
        return this.countUpEnabled;
    }

    public void setCountUpEnabled(boolean countUpEnabled) {
        this.countUpEnabled = countUpEnabled;
    }

    private byte[] getSignedData(byte[] authenticatorData, byte[] clientDataHash) {
        return ByteBuffer.allocate(authenticatorData.length + clientDataHash.length).put(authenticatorData).put(clientDataHash).array();
    }

    private void countUp() {
        if (this.isCountUpEnabled()) {
            ++this.counter;
        }
    }

    public abstract AttestationStatement createAttestationStatement(AttestationStatementRequest var1, RegistrationEmulationOption var2);

    public AttestationStatement createAttestationStatement(AttestationStatementRequest attestationStatementRequest) {
        return this.createAttestationStatement(attestationStatementRequest, new RegistrationEmulationOption());
    }

    abstract X509Certificate createAttestationCertificate(AttestationStatementRequest var1, AttestationOption var2);

    public X509Certificate getAttestationCertificate(AttestationStatementRequest attestationStatementRequest, AttestationOption attestationOption) {
        switch (attestationOption.getX509CertificateVersion()) {
            case 1: {
                return TestAttestationUtil.createV1DummyCertificate();
            }
            case 3: {
                return this.createAttestationCertificate(attestationStatementRequest, attestationOption);
            }
        }
        throw new IllegalArgumentException("Only version 1 or 3 are supported.");
    }

    public KeyPair getAttestationKeyPair() {
        return this.attestationKeyPair;
    }

    public CACertificatePath getCACertificatePath() {
        return this.caCertificatePath;
    }

    public PrivateKey getAttestationIssuerPrivateKey() {
        return this.attestationIssuerPrivateKey;
    }

    public X509Certificate getAttestationIssuerCertificate() {
        if (this.caCertificatePath.isEmpty()) {
            throw new IllegalStateException("caCertificatePath is empty");
        }
        return this.caCertificatePath.get(0);
    }
}

