/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.appattest.converter.jackson.DeviceCheckCBORModule;
import com.webauthn4j.appattest.server.DCServerProperty;
import com.webauthn4j.appattest.verifier.DCRegistrationObject;
import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.authenticator.AuthenticatorImpl;
import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticatorAttestationResponse;
import com.webauthn4j.data.PublicKeyCredential;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.authenticator.Curve;
import com.webauthn4j.data.attestation.authenticator.EC2COSEKey;
import com.webauthn4j.data.attestation.authenticator.RSACOSEKey;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.test.TestAttestationStatementUtil;
import com.webauthn4j.test.TestAttestationUtil;
import com.webauthn4j.test.authenticator.webauthn.exception.WebAuthnModelException;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.Base64Util;
import com.webauthn4j.util.ECUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.util.RSAUtil;
import com.webauthn4j.util.SignatureUtil;
import com.webauthn4j.verifier.CoreRegistrationObject;
import com.webauthn4j.verifier.RegistrationObject;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;

public class TestDataUtil {
    private static final ObjectConverter objectConverter;
    private static final CollectedClientDataConverter collectedClientDataConverter;
    private static final AttestationObjectConverter attestationObjectConverter;
    private static final AuthenticatorDataConverter authenticatorDataConverter;

    private TestDataUtil() {
    }

    public static RegistrationObject createRegistrationObjectWithPackedAttestation() {
        CollectedClientData collectedClientData = TestDataUtil.createClientData(ClientDataType.WEBAUTHN_CREATE);
        byte[] collectedClientDataBytes = collectedClientDataConverter.convertToBytes(collectedClientData);
        byte[] clientDataHash = MessageDigestUtil.createSHA256().digest(collectedClientDataBytes);
        AttestationObject attestationObject = TestDataUtil.createAttestationObjectWithBasicPackedECAttestationStatement(clientDataHash);
        byte[] attestationObjectBytes = attestationObjectConverter.convertToBytes(attestationObject);
        Set transports = Collections.emptySet();
        AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs = new AuthenticationExtensionsClientOutputs();
        return new RegistrationObject(attestationObject, attestationObjectBytes, collectedClientData, collectedClientDataBytes, authenticationExtensionsClientOutputs, transports, TestDataUtil.createServerProperty());
    }

    public static RegistrationObject createRegistrationObjectWithAndroidKeyAttestation() {
        byte[] collectedClientDataBytes = Base64UrlUtil.decode((String)"eyJvcmlnaW4iOiJodHRwOi8vbG9jYWxob3N0OjgwODAiLCJjaGFsbGVuZ2UiOiJ2MmgxYzJWeWJtRnRaWFEwYVY5T2JUUm9iakZEZUVrd1NHYzNPSGh6VFdsamFHRnNiR1Z1WjJWUXR1YkVEQzRPU3BHSGViSExMTmVyRmY4IiwidHlwZSI6IndlYmF1dGhuLmNyZWF0ZSJ9");
        CollectedClientData collectedClientData = collectedClientDataConverter.convert(collectedClientDataBytes);
        byte[] attestationObjectBytes = Base64UrlUtil.decode((String)"o2NmbXRrYW5kcm9pZC1rZXlnYXR0U3RtdKNjYWxnJmNzaWdYSDBGAiEAl0EDZokwnDApmVkWnSc24ELfZCI-Fx3s7K6YLM-W-xACIQCHvO-RPrqBSVV8rHYlWvRUt-UXpwRc4NQPBnVZ6k9CGGN4NWOCWQMEMIIDADCCAqegAwIBAgIBATAKBggqhkjOPQQDAjCBzjFFMEMGA1UEAww8RkFLRSBBbmRyb2lkIEtleXN0b3JlIFNvZnR3YXJlIEF0dGVzdGF0aW9uIEludGVybWVkaWF0ZSBGQUtFMTEwLwYJKoZIhvcNAQkBFiJjb25mb3JtYW5jZS10b29sc0BmaWRvYWxsaWFuY2Uub3JnMRYwFAYDVQQKDA1GSURPIEFsbGlhbmNlMQwwCgYDVQQLDANDV0cxCzAJBgNVBAYTAlVTMQswCQYDVQQIDAJNWTESMBAGA1UEBwwJV2FrZWZpZWxkMCAXDTcwMDIwMTAwMDAwMFoYDzIwOTkwMTMxMjM1OTU5WjApMScwJQYDVQQDDB5GQUtFIEFuZHJvaWQgS2V5c3RvcmUgS2V5IEZBS0UwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAQsOMT5hyL6rg0c9ilM8skJWRYWTG4vpnP2MpS9aOeYzxkCOREmADn0fEDOqrk0EqMoY2RE_NOgN8jqAlHtgFiRo4IBFjCCARIwCwYDVR0PBAQDAgeAMIHhBgorBgEEAdZ5AgERBIHSMIHPAgECCgEAAgEBCgEABCAhLBhI9_zUhPMmw_wgGYR4IbEhgriX50b2mPD1DoesJgQAMGm_hT0IAgYBXtPjz6C_hUVZBFcwVTEvMC0EKGNvbS5hbmRyb2lkLmtleXN0b3JlLmFuZHJvaWRrZXlzdG9yZWRlbW8CAQExIgQgdM_LUHSI9SkQhZHHpQWRnzJ3MvvB2ANSauqYAAbS2JgwMqEFMQMCAQKiAwIBA6MEAgIBAKUFMQMCAQSqAwIBAb-DeAMCAQK_hT4DAgEAv4U_AgUAMB8GA1UdIwQYMBaAFFKaGzLgVqrNUQ_vX4A3BovykSMdMAoGCCqGSM49BAMCA0cAMEQCIAgOX0m5-z0iFe-5iG049P5hmYwJ70PsC1gYvsQyL7SOAiA2cqK2McZgFvnoiGURFVEXR69LKX1gogUaO9IJZhR8TlkC7jCCAuowggKRoAMCAQICAQIwCgYIKoZIzj0EAwIwgcYxPTA7BgNVBAMMNEZBS0UgQW5kcm9pZCBLZXlzdG9yZSBTb2Z0d2FyZSBBdHRlc3RhdGlvbiBSb290IEZBS0UxMTAvBgkqhkiG9w0BCQEWImNvbmZvcm1hbmNlLXRvb2xzQGZpZG9hbGxpYW5jZS5vcmcxFjAUBgNVBAoMDUZJRE8gQWxsaWFuY2UxDDAKBgNVBAsMA0NXRzELMAkGA1UEBhMCVVMxCzAJBgNVBAgMAk1ZMRIwEAYDVQQHDAlXYWtlZmllbGQwHhcNMTgwNTA5MTIzMTQ0WhcNNDUwOTI0MTIzMTQ0WjCBzjFFMEMGA1UEAww8RkFLRSBBbmRyb2lkIEtleXN0b3JlIFNvZnR3YXJlIEF0dGVzdGF0aW9uIEludGVybWVkaWF0ZSBGQUtFMTEwLwYJKoZIhvcNAQkBFiJjb25mb3JtYW5jZS10b29sc0BmaWRvYWxsaWFuY2Uub3JnMRYwFAYDVQQKDA1GSURPIEFsbGlhbmNlMQwwCgYDVQQLDANDV0cxCzAJBgNVBAYTAlVTMQswCQYDVQQIDAJNWTESMBAGA1UEBwwJV2FrZWZpZWxkMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEq1BhK2JNF7vDtRsESTsFSQuMH4udvPN5st7coHxSode2DdMhddwrft28JtsI1V-G9nG2lNwwTaSiioxOA6b1x6NmMGQwEgYDVR0TAQH_BAgwBgEB_wIBADAOBgNVHQ8BAf8EBAMCAoQwHQYDVR0OBBYEFKPSqizvDYzyJALVHLRgvL9qWyQUMB8GA1UdIwQYMBaAFFKaGzLgVqrNUQ_vX4A3BovykSMdMAoGCCqGSM49BAMCA0cAMEQCIGndnqPxgftCSjmtGgrfudLjM9eG_rlFYFX6PcyZeLnSAiA-0w-m9wa1VukUJCqwZvKHE92SOLyW1xhdBV8yF1SlFmhhdXRoRGF0YVikSZYN5YgOjGh0NBcPZHZgW4_krrmihjLHmVzzuoMdl2NBAAAARlUOS1SqR0CfmpUat2wTATEAIHEiziyGohCFUc_hJJZGdtSu9ThnEb74K6NZC3U-KbwgpQECAyYgASFYICw4xPmHIvquDRz2KUzyyQlZFhZMbi-mc_YylL1o55jPIlggGQI5ESYAOfR8QM6quTQSoyhjZET806A3yOoCUe2AWJE");
        AttestationObject attestationObject = attestationObjectConverter.convert(attestationObjectBytes);
        Set transports = Collections.emptySet();
        AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs = new AuthenticationExtensionsClientOutputs();
        return new RegistrationObject(attestationObject, attestationObjectBytes, collectedClientData, collectedClientDataBytes, authenticationExtensionsClientOutputs, transports, TestDataUtil.createServerProperty());
    }

    public static RegistrationObject createRegistrationObjectWithAndroidSafetyNetAttestation() {
        byte[] collectedClientDataBytes = Base64UrlUtil.decode((String)"eyJvcmlnaW4iOiJodHRwOi8vbG9jYWxob3N0OjgwODAiLCJjaGFsbGVuZ2UiOiJ2MmgxYzJWeWJtRnRaWFF5TFRKTWNGaEhNV2hXWm14V1RYbGxjSE40YzJsamFHRnNiR1Z1WjJWUXByUl9fSkRUUUotY2JZN3NYb1R4RFA4IiwidHlwZSI6IndlYmF1dGhuLmNyZWF0ZSJ9");
        CollectedClientData collectedClientData = collectedClientDataConverter.convert(collectedClientDataBytes);
        byte[] attestationObjectBytes = Base64UrlUtil.decode((String)"o2NmbXRxYW5kcm9pZC1zYWZldHluZXRnYXR0U3RtdKJjdmVyaDEyNjg1MDIzaHJlc3BvbnNlWRWVZXlKaGJHY2lPaUpTVXpJMU5pSXNJbmcxWXlJNld5Sk5TVWxHVUVSRFEwSkRVMmRCZDBsQ1FXZEpVRUpPV1RWWldFZFJNRVY0VTNWbVMwWlViRXROVFVFd1IwTlRjVWRUU1dJelJGRkZRa04zVlVGTlJ6UjRRM3BCU2tKblRsWkNRVmxVUVd4V1ZFMVRjM2RMVVZsRVZsRlJTMFJEU2tkVFZWSlFTVVZHYzJKSGJHaGliVTVzWTNsQ1IxRlZkRVpKUmxKNVpGaE9NRWxHVG14amJscHdXVEpXZWsxVVNYZE5RVmxFVmxGUlJFUkRiRWRUVlZKUVNVVkdjMkpIYkdoaWJVNXNZM2xDUjFGVmRFWkpSV3gxWkVkV2VXSnRWakJKUlVZeFpFZG9kbU50YkRCbFUwSkhUVlJCWlVaM01IaFBSRUY1VFVSRmQwMUVRWGROUkVKaFJuY3dlVTFFUVhsTlJFbDNUbnBCZDA1VWJHRk5TRVY0UTNwQlNrSm5UbFpDUVZsVVFXeFdWRTFSYzNkRFVWbEVWbEZSU1VSQlNrNVhWRVZUVFVKQlIwRXhWVVZDZDNkS1ZqSkdjbHBYV25CYVYzaHJUVkpaZDBaQldVUldVVkZMUkVFeFIxTlZVbEJKUlVaellrZHNhR0p0VG14TlVYZDNRMmRaUkZaUlVVeEVRVTVFVmpCamVFZDZRVnBDWjA1V1FrRk5UVVZ0UmpCa1IxWjZaRU0xYUdKdFVubGlNbXhyVEcxT2RtSlVRME5CVTBsM1JGRlpTa3R2V2tsb2RtTk9RVkZGUWtKUlFVUm5aMFZRUVVSRFEwRlJiME5uWjBWQ1FVNXVVM2hvT1hrdldqRjNSV0ZVV2xjdmJTOVdORk52VjFwbVpHVTNTMnA2WW10SmRFRnNVbUZpYW1KdFUxRmFSamw2VDNwSlJ6Um1TU3RXZUVveFduQTFVVFpXWVd0clF6UXlWRWd2WW05TVRGbHNRamhxYjFGVFNsZHBTM1ZHTDNkQ2FWWkVSeXRuVEd3ck9WUldhekI1ZFc5V1RHSTVVMkpPYnpVNE4wVjNlbTUwVlVjeGRGTk9VMWhPTlVVck1raEhNeTlaYVhwMFdFNU5OSFJuUkhOc1ZuQkdTSEZXUVZaRmNHNUxWMlZYVTA0ellXa3ZkR2h1Wm1Sa2IzQTFSVk15ZFZsMlRtOU9jMDVaYWpOcVRHTkxORWRKZVhBd1kyRjNWVEpGWlM5eFdIWkdjalZHUVdOT01GZ3pSVXRNYmxreFQwRm5abFppTWxoNlRqUjZVbmwxT1ZoRGJXZHZVR0ZwZEZOMldHOVJSRWR0UVdNeU5WQmxkamhEY2xjMUx6aHNhREJQYlRsNGNtMVFkRmhNVlZwU2QydDFjVkJXVFRSMGNGSnJOVzFTU21oVFJFWmlVV3AzZVhneWR5dEhPVmgyYlZOaVkwTkJkMFZCUVdGUFEwRmtTWGRuWjBoUFRVTkZSMEV4VldSSlFWRmhUVUpuZDBSQldVdExkMWxDUWtGSVYyVlJTVVpCZWtGSlFtZGFibWRSZDBKQlowbDNSWGRaUkZaU01HeENRWGQzUTJkWlNVdDNXVUpDVVZWSVFYZEZkMFJCV1VSV1VqQlVRVkZJTDBKQlNYZEJSRUZtUW1kT1ZraFJORVZIUVZGWGQyaFNVbXhXU2xCRFQxaE9SMlpTTjJkQ1FVVnlUVGRDU0RGTWVEaDZRV1pDWjA1V1NGTk5SVWRCVVZkdlFsRnRVSGsxYVRGQ1NuUXlOU3RMTm5odWJXUlBNa1YwVUdoaGMycENWRUpuVGxaSVVqaEZWRVJDUzAxRmFXZFNjVUpGYUd0S2IyUklVbmRqZW05MlRESmFjRnBIT1doaVIzaHdXVmMxYWxwVE5XcGllVFYxWldrNWVsbFhXbXhrU0d4MVdsaFNkMkV5YTNaWk0wcHpUREpHTUdSSFZucGtRelZvWW0xU2VXSXliR3RNYlU1MllsTTFhbU50ZDNkblpUUkhRME56UjBGUlZVWkNkMFZDUWtsSWFFMUpTR1ZOUjNOSFEwTnpSMEZSVlVaQ2VrRkRhR3c1YjJSSVVuZGplbTkyVERKYWNGcEhPV2hpUjNod1dWYzFhbHBUTldwaWVUVjFaV2s1ZWxsWFdteGtTR3gxV2xoU2QyRXlhM1pTYTJ4RlZIbFZlVTFGV21oaE1sVnNUV3BDVTJJeU9UQktWRWwzVVRKV2VXUkhiRzFoVjA1b1pFZFZiRTFxUWtKa1dGSnZZak5LY0dSSWEyeE5ha0Y1VFVSRk5FeHRUbmxrUkVKMlFtZG5ja0puUlVaQ1VXTjNRVmxhYW1GSVVqQmpTRTAyVEhrNWJXRlhVblpaVjNoellWZEdkVmt5VlhWWk1qaDFZbTV2ZG1NeVJtMWFXRkkxWW0xV01HTkhkSEJNTWs1NVlrTTVSMU5WVWxCS1ZFbDNVbTFHY2xwVFZYbE5Sa3AyWWpOUmJFMXFRa1JhV0Vvd1lWZGFjRmt5UmpCYVUxVjVUVVZHTVdSSGFIWmpiV3d3WlZOVmVVMUVTWGROVkdkMVdUTktjMDFCTUVkRFUzRkhVMGxpTTBSUlJVSkRkMVZCUVRSSlFrRlJRV2hJUzNsNWVuTklNV2Q1YjB0UGRqQXZjMGhwTlZCQ1NHbFpiMkUzYkUxWVQxVlZZbVF3VnpnNU5UTXpjamxoZFdFd1FYRkVSVGg2UkhBMWJuVnlaVE5KZUhoeldXWm5ha2wzY1ZsSmREaGlibHBSU1RGVkx6UnROVWh3TUc5M1oxcFlhM3BUUjJaWVJGaE5ZVXczZEZBcldrTTFhMEV4WjFOSVYySmtjRzFTVVdwUVVERXJLemRHZGpsSGFVZHBkRlUyUmtaUFRUUXdia05YUzNwYVptVldTSGt5VDNVMWRqUjZVVEJKTm1SWVZrUmFSbW95ZGpoVldsUlRVbEpNVGpOSldVRmlVbTlHTlVkbFUwVktTSEZXVlM5blowWkJOVmRpWm5ObGRHVllXSFpXTUd4NGVub3diMFJtWTJsb2VtaFdVMUZOVldSTE1tcFFkbk56TW5aM2NtTjVkVE50YkVwdFlsbFBlVzVzZG5keFUxWk9jM1JoYjBSTmEzUnhSVlpXUlVzd1JHdDBURGRDVG1GeVRqa3daRzh3SzFoa1EwcHFLeTl1Y0cxSlMyaFhja2hHT0U4NVlrSXdaR3RtTVdoc1ZqWXhJaXdpVFVsSlJrUjZRME5CTDJWblFYZEpRa0ZuU1ZCQ1QzQTRjRVZRVG5kamR6aG1aVnBKUlUwclEwMUJNRWREVTNGSFUwbGlNMFJSUlVKRGQxVkJUVVpCZUVONlFVcENaMDVXUWtGWlZFRnNWbFJOVWxsM1JrRlpSRlpSVVV0RVFURkhVMVZTVUVsRlJuTmlSMnhvWW0xT2JFMVRhM2RLZDFsRVZsRlJSRVJEUWtkVFZWSlFTVVZHYzJKSGJHaGliVTVzWTNsQ1IxRlZkRVpKUmtwMllqTlJaMUV3UldkTVUwSlVUVlJCWlVaM01IaE9la0Y1VFVSRmQwMUVRWGROUkVKaFJuY3dlazVVUVhoTmVrVjVUWHBWTlU1VWJHRk5SelI0UTNwQlNrSm5UbFpDUVZsVVFXeFdWRTFUYzNkTFVWbEVWbEZSUzBSRFNrZFRWVkpRU1VWR2MySkhiR2hpYlU1c1kzbENSMUZWZEVaSlJsSjVaRmhPTUVsR1RteGpibHB3V1RKV2VrMVVTWGROUVZsRVZsRlJSRVJEYkVkVFZWSlFTVVZHYzJKSGJHaGliVTVzWTNsQ1IxRlZkRVpKUld4MVpFZFdlV0p0VmpCSlJVWXhaRWRvZG1OdGJEQmxVMEpIVFZSRFEwRlRTWGRFVVZsS1MyOWFTV2gyWTA1QlVVVkNRbEZCUkdkblJWQkJSRU5EUVZGdlEyZG5SVUpCU21aVmRtcGpWMU4wWVM4MlEyUmlSbmRZYkZSeVFXVnBSekJDUkdwdlNIcEVialZaZURkU05rUnFjV1ZNU0hsRGVFUTFWbGw0WldGMkwzSlFjVkJCWldKd1kyNWpSbkF3UTBwYWVXWnZWRE15ZFVsWmF6RlVUblI0Y0haWWJUUnFPVWhwZWtKaVUxVTJXVXhCY3pKRWVqZFhTRU0yUWxOeFJHZ3lTa1J4TkdOdmNqZFVSSEEyUVVNeFV5OUVRV2RPY0RSU05WaHVORXAxUjA4M2RIVm9kM2xDVkZkWGVtTkhVSEl6Vm5aTVNWQm1PWEI1UVdOdGFsSTFhR3AzTkhZeFJUaE5kVmxTVDFOWFoxZEZRVmxaSzNCcWJsSXhXRVYxWlVkaWRVdzRWMW8xVnpKT2RFWlJiRkZaZG1KT1ZFUnpZMWxLVkdOT1EzbDBNMDlYWmpsTmRFNUdlbUpxTUhSVGRHVlJjQ3R3WVN0aWFVa3ZLMkZ1U0ZOQ1NHcHVObGhKYm5kdFQxZHZhRkI0TVdwMVltTllWa0ZIYW5GVFZYUnFXa050VkVkUFIxSmtUbHBWYTFacFozZEpSbU5zWkhwd1ZGSXJVek5WUTBGM1JVRkJZVTlEUVdOWmQyZG5TRU5OUVhOSFFURlZaRVIzVVVWQmQwbENhR3BDVEVKblRsWklVMEZGVWtSQ1EwMUZRVWRDYldWQ1JFRkZRMEZxUVRKTlJGRkhRME56UjBGUlZVWkNkMGxDUm1sb2IyUklVbmRqZW05MlRESmFjRnBIT1doaVIzaHdXVmMxYWxwVE5XcGllVFYxWldrNWVsbFhXbXhrU0d4MVdsaFNkMkV5YTNaTlFqQkhRVEZWWkVwUlVWZE5RbEZIUTBOelIwRlJWVVpDZDAxQ1FtZG5ja0puUlVaQ1VXTkVRV3BCVTBKblRsWklVazFDUVdZNFJVTkVRVWRCVVVndlFXZEZRVTFDT0VkQk1WVmtSR2RSV1VKQ1lrTkdRMWt2VEcxTVZVVnRNMkp1TkhKeVIyVmFNRGRaVXpBclJuRjVUVUk0UjBFeFZXUkpkMUZaUWtKaFowWkxiekl2TUVad01IQXlTMDg1WjJOYVpFNWlNMjEwZDB4YVUxRk5TRkZIUVRGVlpFaDNVblJOUjNOM1lXRkNibTlIVjBkWk1tZ3daRWhDZWs5cE9IWmFiV3hyWWpKR2MySkhiR2hpYlU1c1RHMU9ka3h0TlRaTU0wNW9XbTFXTUdWWE5XeGtTRUp5WVZNNWFtTnRkM1pTYTJ4RlZIbFZlVTFGV21oaE1sVnNUV3BDVTJJeU9UQktWRWwzVVRKV2VXUkhiRzFoVjA1b1pFZFZiRTFxUWtKa1dGSnZZak5LY0dSSWEyeE5ha0Y1VFVSRk5FeHRUbmxpUkVJM1FtZG5ja0puUlVaQ1VXTkNRVkZTZGsxSE1IZGhkMWxKUzNkWlFrSlJWVWhOUVVkSFdESm9NR1JJUW5wUGFUaDJXbTFzYTJJeVJuTmlSMnhvWW0xT2JFeHRUblpNYlRVMlRETk9hRnB0VmpCbFZ6VnNaRWhDY21GVE9VZFRWVkpRU2xSSmQxSnRSbkphVTFWNVRVWktkbUl6VVd4TmFrSkVXbGhLTUdGWFduQlpNa1l3V2xOVmVVMUZSakZrUjJoMlkyMXNNR1ZUVlhsTlJFbDNUVlJuZFZrelNqQk5RVEJIUTFOeFIxTkpZak5FVVVWQ1EzZFZRVUUwU1VKQlVVRjJTRFpGYkVJdmRXUlFaMVp4YVdGaWNtMUNZMmxJUzJGQ09WSTJVR1UwYUVsWVN6ZG1UVXByZEhBd1dFNHdWVmxSU0V0a2VHWTRiVFJqTUVoeFJuSk5jMVJQWjA0cmRXbHFZMDFJUWtKRVZFTnBLMjlhZDNoRFpWWm1WWG80WVRsa1VVSjBiRTlFY2twclkwNVdjVWxZWjB4NFFtSm1hMDR2UWxobGJIaFNaazFxYVM5RVJreFZhRmw0ZEVwSVNGWjJXbkpzU2xkWmQyRkpNMlkzVTNOVGVtaElSWEZITDNKS2NXcDJWbnBRU0cxNGFsTm5VMUpzTVV4c05EQTFabGs0TlVvd05UTm1NemRVYW1ZMFZIcDRNMWx0VXpWQ1FscEZVVmxxZURsR1UwUXdNM0ZFUVd0UU1rVlJRVzlMT1VSNFpHSkdNV2xJYVM4eGExbzRURWhUUVZwcU0xTlllVGRzYTFGT2VWZHhha3RpWlc1SFF5dHlSamR6TWxjeFFWRTBhalEzUWxoM1VqRlNNVzlqUlVSV04xcEtNbloxUzI5NVNDOXJSQzh3VDJscU5sUktOMkp5T0hOWVJHRkNaalJQYUdzclNTSmRmUS5leUp1YjI1alpTSTZJazB6T1Zsb00yTm5VVll5YzJGV1NtWlhUbTVTUTIwM1JDdFhRWGR1V2pkMFEwRm9VWGcxWVdKdGFsRTlJaXdpZEdsdFpYTjBZVzF3VFhNaU9qRTFORGt3T1RBNE5Ua3lOREFzSW1Gd2ExQmhZMnRoWjJWT1lXMWxJam9pWTI5dExtRnVaSEp2YVdRdWEyVjVjM1J2Y21VdVlXNWtjbTlwWkd0bGVYTjBiM0psWkdWdGJ5SXNJbUZ3YTBScFoyVnpkRk5vWVRJMU5pSTZJbVJOTDB4VlNGTkpPVk5yVVdoYVNFaHdVVmRTYm5wS00wMTJka0l5UVU1VFlYVnhXVUZCWWxNeVNtYzlJaXdpWVhCclEyVnlkR2xtYVdOaGRHVkVhV2RsYzNSVGFHRXlOVFlpT2xzaVluTmlOQzlYVVdSaFlVOVhXVU5rTDJvNVQwcHBVWEJuTjJJd2FYZEdaMEZqTDNwNlFURjBRMlozUlQwaVhTd2lZM1J6VUhKdlptbHNaVTFoZEdOb0lqcDBjblZsTENKaVlYTnBZMGx1ZEdWbmNtbDBlU0k2ZEhKMVpYMC4xUE5HWnNUbVNXTlI5Umt3am5tT2hEdS1TZS1NX3BYQjhoRWg1elpGOUtqZXBRMllWbEJybi1nTjZVdGRMd2NkN3JjbXlORnkxUWw5OW1vQ2EySUZEcTdxcEdlcDZIRnZyeThXU2J2Qk1NUllHYVVsYUVQekl0QnZKaXJFNHhic182cWJhTDlzaWs3Y1dtRTM2RUF2V1JIZEg0Q1Exbk9zcThhZG8yTW4ta0VIZXpXLUJscFNVZ2hfWW5tX3BnR2pad3RGd0VER3BNVEhaYWJoVWFkTnAxTGprMkFOSEUwSXlvQkJSZGU2QWxpOWo1UUtldm9CZU5oRzZpQUpSQjVHbmx4ek5IaG1lRk5lZk9JM2RmRXgzOGZoUE5NUnlNd0JzRUZxSHJxQWZDQVJWek96VXJfV3hpOGN3ZEE0MVItZFlMMjdNSTdtcHRab1U5VzVhS3NQX0FoYXV0aERhdGFZAWdJlg3liA6MaHQ0Fw9kdmBbj-SuuaKGMseZXPO6gx2XY0EAAACUyHzdl1bBSbieJMs2NlTzUAAgoTaqg-uoaPbjf_WOSn57I5m3u5kQqb4FtWyANNpm1MakAQMDOQEAIFkBANIgdpYtfXjH-yGYu7kbu6giXuoCvGY0F3HuTC_yYVaSewHECwWCklEpl3kfHW2umFfvGSaifZWkYWIigZwDlV1aKGbuiXswDpqHX59QVHqjNGrSGtid_Nbu48xb8Cc4sUBkfFRTExKsCUEN-Xfbezx8tELtEd9AVKQVxaCLf30DN61C_hBNew_3oEt0hHeCPlYfzkkVYDRIjMf8Ud7phpBJM_vfEoz30xsXuoZFWhwhskicjtcHRI5Hyvz7z4korABDz6sYlELblzH2v7F-74Rt0u1Hw76cQ4X0BQxgtelwS5pbV_I8wdYReti5HLwgT0eH9zBbtWNC51sn00x8KDEhQwEAAQ");
        AttestationObject attestationObject = attestationObjectConverter.convert(attestationObjectBytes);
        Set transports = Collections.emptySet();
        AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs = new AuthenticationExtensionsClientOutputs();
        Instant timestamp = Instant.parse("2019-02-02T07:01:00.00Z");
        return new RegistrationObject(attestationObject, attestationObjectBytes, collectedClientData, collectedClientDataBytes, authenticationExtensionsClientOutputs, transports, TestDataUtil.createServerProperty(), timestamp);
    }

    public static DCRegistrationObject createRegistrationObjectWithAppleAppAttestAttestation() {
        byte[] keyId = Base64Util.decode((String)"VnfqjSp0rWyyqNhrfh+9/IhLIvXuYTPAmJEVQwl4dko=");
        byte[] attestationObjectBytes = Base64Util.decode((String)"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");
        byte[] challenge = "1234567890abcdefgh".getBytes();
        byte[] clientDataHash = MessageDigestUtil.createSHA256().digest(challenge);
        DCServerProperty dcServerProperty = new DCServerProperty("8YE23NZS57.com.kayak.travel", (Challenge)new DefaultChallenge(challenge));
        AttestationObject attestationObject = attestationObjectConverter.convert(attestationObjectBytes);
        Instant timestamp = Instant.parse("2020-08-18T13:37:00Z");
        return new DCRegistrationObject(keyId, attestationObject, attestationObjectBytes, clientDataHash, (CoreServerProperty)dcServerProperty, timestamp);
    }

    public static CoreRegistrationObject createCoreRegistrationObjectWithAppleAppAttestAttestation() {
        byte[] collectedClientDataBytes = Base64UrlUtil.decode((String)"eyJvcmlnaW4iOiJodHRwOi8vbG9jYWxob3N0OjgwODAiLCJjaGFsbGVuZ2UiOiJkM1Z5ZW1Wc2NHWnliM0JtIiwidHlwZSI6IndlYmF1dGhuLmNyZWF0ZSJ9");
        byte[] clientDataHash = MessageDigestUtil.createSHA256().digest(collectedClientDataBytes);
        byte[] attestationObjectBytes = Base64UrlUtil.decode((String)"o2NmbXRvYXBwbGUtYXBwYXR0ZXN0Z2F0dFN0bXSiY3g1Y4JZAvYwggLyMIICeaADAgECAgYBc_5ZDswwCgYIKoZIzj0EAwIwTzEjMCEGA1UEAwwaQXBwbGUgQXBwIEF0dGVzdGF0aW9uIENBIDExEzARBgNVBAoMCkFwcGxlIEluYy4xEzARBgNVBAgMCkNhbGlmb3JuaWEwHhcNMjAwODE3MjEyNTE2WhcNMjAwODE4MjEzNTE2WjCBkTFJMEcGA1UEAwxANTQ0ZTk0ODEwNTA5MTNlOThjMzRiYzg5MmM5ZjI1Y2NmMGM4YmQ0NjA3YTdmNjdkZGUzMjE2MDA4ZDk5MTU3YjEaMBgGA1UECwwRQUFBIENlcnRpZmljYXRpb24xEzARBgNVBAoMCkFwcGxlIEluYy4xEzARBgNVBAgMCkNhbGlmb3JuaWEwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAR3d82Uh2zHPFbH86C-5P3SNOg37xIM0bRuqoz0uSTkSFboZc99_wFlXW0MZKruzD0UAHWmg9KyBk4Q0vlhJ0CTo4H9MIH6MAwGA1UdEwEB_wQCMAAwDgYDVR0PAQH_BAQDAgTwMIGJBgkqhkiG92NkCAUEfDB6pAMCAQq_iTADAgEBv4kxAwIBAL-JMgMCAQC_iTMDAgEBv4k0MQQvNk1VUkw4VEE1Ny5kZS52aW5jZW50LWhhdXBlcnQuQXBwbGVBcHBBdHRlc3RQb2OlBgQEIHNrc7-JNgMCAQW_iTcDAgEAv4k5AwIBAL-JOgMCAQAwGQYJKoZIhvdjZAgHBAwwCr-KeAYEBDE0LjAwMwYJKoZIhvdjZAgCBCYwJKEiBCDQ15p0EcOQ8Mbd8dydsxxwAcUH8Rlf08_mEnqMVi31CDAKBggqhkjOPQQDAgNnADBkAjAaYGf7yCNvOT-SvNUOuNz-0mwbVW3ot06vjOShf0q9sE4nNc5tBLVnWimwEyNyBkwCMGrF8x7QNnhDYbe9EVISe1e_Kw-yI5pu0wX-O8OVta6f_XgnC6PkkKTZJHkApVGTPlkCRzCCAkMwggHIoAMCAQICEAm6xeG8QBrZ1FOVvDgaCFQwCgYIKoZIzj0EAwMwUjEmMCQGA1UEAwwdQXBwbGUgQXBwIEF0dGVzdGF0aW9uIFJvb3QgQ0ExEzARBgNVBAoMCkFwcGxlIEluYy4xEzARBgNVBAgMCkNhbGlmb3JuaWEwHhcNMjAwMzE4MTgzOTU1WhcNMzAwMzEzMDAwMDAwWjBPMSMwIQYDVQQDDBpBcHBsZSBBcHAgQXR0ZXN0YXRpb24gQ0EgMTETMBEGA1UECgwKQXBwbGUgSW5jLjETMBEGA1UECAwKQ2FsaWZvcm5pYTB2MBAGByqGSM49AgEGBSuBBAAiA2IABK5bN6B3TXmyNY9A59HyJibxwl_vF4At6rOCalmHT_jSrRUleJqiZgQZEki2PLlnBp6Y02O9XjcPv6COMp6Ac6mF53Ruo1mi9m8p2zKvRV4hFljVZ6-eJn6yYU3CGmbOmaNmMGQwEgYDVR0TAQH_BAgwBgEB_wIBADAfBgNVHSMEGDAWgBSskRBTM72-aEH_pwyp5frq5eWKoTAdBgNVHQ4EFgQUPuNdHAQZqcm0MfiEdNbh4Vdy45swDgYDVR0PAQH_BAQDAgEGMAoGCCqGSM49BAMDA2kAMGYCMQC7voiNc40FAs-8_WZtCVdQNbzWhyw_hDBJJint0fkU6HmZHJrota7406hUM_e2DQYCMQCrOO3QzIHtAKRSw7pE-ZNjZVP-zCl_LrTfn16-WkrKtplcS4IN-QQ4b3gHu1iUObdncmVjZWlwdFkPDjCABgkqhkiG9w0BBwKggDCAAgEBMQ8wDQYJYIZIAWUDBAIBBQAwgAYJKoZIhvcNAQcBoIAkgASCA-gxggQuMDcCAQICAQEELzZNVVJMOFRBNTcuZGUudmluY2VudC1oYXVwZXJ0LkFwcGxlQXBwQXR0ZXN0UG9jMIIDAAIBAwIBAQSCAvYwggLyMIICeaADAgECAgYBc_5ZDswwCgYIKoZIzj0EAwIwTzEjMCEGA1UEAwwaQXBwbGUgQXBwIEF0dGVzdGF0aW9uIENBIDExEzARBgNVBAoMCkFwcGxlIEluYy4xEzARBgNVBAgMCkNhbGlmb3JuaWEwHhcNMjAwODE3MjEyNTE2WhcNMjAwODE4MjEzNTE2WjCBkTFJMEcGA1UEAwxANTQ0ZTk0ODEwNTA5MTNlOThjMzRiYzg5MmM5ZjI1Y2NmMGM4YmQ0NjA3YTdmNjdkZGUzMjE2MDA4ZDk5MTU3YjEaMBgGA1UECwwRQUFBIENlcnRpZmljYXRpb24xEzARBgNVBAoMCkFwcGxlIEluYy4xEzARBgNVBAgMCkNhbGlmb3JuaWEwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAR3d82Uh2zHPFbH86C-5P3SNOg37xIM0bRuqoz0uSTkSFboZc99_wFlXW0MZKruzD0UAHWmg9KyBk4Q0vlhJ0CTo4H9MIH6MAwGA1UdEwEB_wQCMAAwDgYDVR0PAQH_BAQDAgTwMIGJBgkqhkiG92NkCAUEfDB6pAMCAQq_iTADAgEBv4kxAwIBAL-JMgMCAQC_iTMDAgEBv4k0MQQvNk1VUkw4VEE1Ny5kZS52aW5jZW50LWhhdXBlcnQuQXBwbGVBcHBBdHRlc3RQb2OlBgQEIHNrc7-JNgMCAQW_iTcDAgEAv4k5AwIBAL-JOgMCAQAwGQYJKoZIhvdjZAgHBAwwCr-KeAYEBDE0LjAwMwYJKoZIhvdjZAgCBCYwJKEiBCDQ15p0EcOQ8Mbd8dydsxxwAcUH8Rlf08_mEnqMVi31CDAKBggqhkjOPQQDAgNnADBkAjAaYGf7yCNvOT-SvNUOuNz-0mwbVW3ot06vjOShf0q9sE4nNc5tBLVnWimwEyNyBkwCMGrF8x7QNnhDYbe9EVISe1e_Kw-yI5pu0wX-O8OVta6f_XgnC6PkkKTZJHkApVGTPjAoAgEEAgEBBCCiVw27oN9-WCddul3ygpxKHdZgM7BoSfaI0gVS0hT9ADBgAgEFAgEBBFhiazdBOWROL0ZyYUM0aFV3MnJCTHNCaU5sY3F4QWRFenFqSW9ZcE5kYURQdU1Ub2ZVekRvVGNuNzRlcE9INC9oeFBWY2VNNjQ0YUlmbnBjTE1oMW1jUT09MA4CAQYCAQEEBkFUVEVTVDAPAgEHAgEBBAdzBEphbmRib3gwIAIBDAIBAQQYMjAyMC0wOC0xN1QyMTozNToxNi4xOTFaMCACARUCAQEEGDIwMjAtMTEtMTVUMjE6MzU6MTYuMTkxWgAAAAAAAKCAMIIDrTCCA1SgAwIBAgIQWTNWreVZgs9EQjes30UbUzAKBggqhkjOPQQDAjB8MTAwLgYDVQQDDCdBcHBsZSBBcHBsaWNhdGlvbiBJbnRlZ3JhdGlvbiBDQSA1IC0gRzExJjAkBgNVBAsMHUFwcGxlIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRMwEQYDVQQKDApBcHBsZSBJbmMuMQswCQYDVQQGEwJVUzAeFw0yMDA1MTkxNzQ3MzFaFw0yMTA2MTgxNzQ3MzFaMFoxNjA0BgNVBAMMLUFwcGxpY2F0aW9uIEF0dGVzdGF0aW9uIEZyYXVkIFJlY2VpcHQgU2lnbmluZzETMBEGA1UECgwKQXBwbGUgSW5jLjELMAkGA1UEBhMCVVMwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAR_6RU0bMOKe5g8k9HQQ1_Yq9pWcATTLFiGZVGVerR498sq-LpF9_p46sYsSeT5zcCEtQMU8QIz2pt2-kQqK7hyo4IB2DCCAdQwDAYDVR0TAQH_BAIwADAfBgNVHSMEGDAWgBTZF_5LZ5A4S5L0287VV4AUC489yTBDBggrBgEFBQcBAQQ3MDUwMwYIKwYBBQUHMAGGJ2h0dHA6Ly9vY3NwLmFwcGxlLmNvbS9vY3NwMDMtYWFpY2E1ZzEwMTCCARwGA1UdIASCARMwggEPMIIBCwYJKoZIhvdjZAUBMIH9MIHDBggrBgEFBQcCAjCBtgyBs1JlbGlhbmNlIG9uIHRoaXMgY2VydGlmaWNhdGUgYnkgYW55IHBhcnR5IGFzc3VtZXMgYWNjZXB0YW5jZSBvZiB0aGUgdGhlbiBhcHBsaWNhYmxlIHN0YW5kYXJkIHRlcm1zIGFuZCBjb25kaXRpb25zIG9mIHVzZSwgY2VydGlmaWNhdGUgcG9saWN5IGFuZCBjZXJ0aWZpY2F0aW9uIHByYWN0aWNlIHN0YXRlbWVudHMuMDUGCCsGAQUFBwIBFilodHRwOi8vd3d3LmFwcGxlLmNvbS9jZXJ0aWZpY2F0ZWF1dGhvcml0eTAdBgNVHQ4EFgQUaR7HD0fs443ddTdE8-nhWmwQViUwDgYDVR0PAQH_BAQDAgeAMA8GCSqGSIb3Y2QMDwQCBQAwCgYIKoZIzj0EAwIDRwAwRAIgJRgWXF4pnFn2hTmtXduZ9jc-9g7NCEWp_Xca1iQtLCICIF0qmypfq6NjgWWNGED3r0gL12uhlNg0IIf01pNbtRuuMIIC-TCCAn-gAwIBAgIQVvuD1Cv_jcM3mSO1Wq5uvTAKBggqhkjOPQQDAzBnMRswGQYDVQQDDBJBcHBsZSBSb290IENBIC0gRzMxJjAkBgNVBAsMHUFwcGxlIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRMwEQYDVQQKDApBcHBsZSBJbmMuMQswCQYDVQQGEwJVUzAeFw0xOTAzMjIxNzUzMzNaFw0zNDAzMjIwMDAwMDBaMHwxMDAuBgNVBAMMJ0FwcGxlIEFwcGxpY2F0aW9uIEludGVncmF0aW9uIENBIDUgLSBHMTEmMCQGA1UECwwdQXBwbGUgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxEzARBgNVBAoMCkFwcGxlIEluYy4xCzAJBgNVBAYTAlVTMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEks5jvX2GsasoCjsc4a_7BJSAkaz2Md-myyg1b0RL4SHlV90SjY26gnyVvkn6vjPKrs0EGfEvQyX69L6zy4N-uqOB9zCB9DAPBgNVHRMBAf8EBTADAQH_MB8GA1UdIwQYMBaAFLuw3qFYM4iapIqZ3r6966_ayySrMEYGCCsGAQUFBwEBBDowODA2BggrBgEFBQcwAYYqaHR0cDovL29jc3AuYXBwbGUuY29tL29jc3AwMy1hcHBsZXJvb3RjYWczMDcGA1UdHwQwMC4wLKAqoCiGJmh0dHA6Ly9jcmwuYXBwbGUuY29tL2FwcGxlcm9vdGNhZzMuY3JsMB0GA1UdDgQWBBTZF_5LZ5A4S5L0287VV4AUC489yTAOBgNVHQ8BAf8EBAMCAQYwEAYKKoZIhvdjZAYCAwQCBQAwCgYIKoZIzj0EAwMDaAAwZQIxAI1vpp-h4OTsW05zipJ_PXhTmI_02h9YHsN1Sv44qEwqgxoaqg2mZG3huZPo0VVM7QIwZzsstOHoNwd3y9XsdqgaOlU7PzVqyMXmkrDhYb6ASWnkXyupbOERAqrMYdk4t3NKMIICQzCCAcmgAwIBAgIILcX8iNLFS5UwCgYIKoZIzj0EAwMwZzEbMBkGA1UEAwwSQXBwbGUgUm9vdCBDQSAtIEczMSYwJAYDVQQLDB1BcHBsZSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTETMBEGA1UECgwKQXBwbGUgSW5jLjELMAkGA1UEBhMCVVMwHhcNMTQwNDMwMTgxOTA2WhcNMzkwNDMwMTgxOTA2WjBnMRswGQYDVQQDDBJBcHBsZSBSb290IENBIC0gRzMxJjAkBgNVBAsMHUFwcGxlIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRMwEQYDVQQKDApBcHBsZSBJbmMuMQswCQYDVQQGEwJVUzB2MBAGByqGSM49AgEGBSuBBAAiA2IABJjpLz1AcqTtkyJygRMc3RCV8cWjTnHcFBbZDuWmBSp3ZHtfTjjTuxxEtX_1H7YyYl3J6YRbTzBPEVoA_VhYDKX1DyxNB0cTddqXl5dvMVztK517IDvYuVTZXpmkOlEKMaNCMEAwHQYDVR0OBBYEFLuw3qFYM4iapIqZ3r6966_ayySrMA8GA1UdEwEB_wQFMAMBAf8wDgYDVR0PAQH_BAQDAgEGMAoGCCqGSM49BAMDA2gAMGUCMQCD6cHEFl4aXTQY2e3v9GwOAEZLuN-yRhHFD_3meoyhpmvOwgPUnPWTxnS4at-qIxUCMG1mihDK1A3UT82NQz60imOlM27jbdoXt2QfyFMm-YhidDkLF1vLUagM6BgD56KyKAAAMYIBlzCCAZMCAQEwgZAwfDEwMC4GA1UEAwwnQXBwbGUgQXBwbGljYXRpb24gSW50ZWdyYXRpb24gQ0EgNSAtIEcxMSYwJAYDVQQLDB1BcHBsZSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTETMBEGA1UECgwKQXBwbGUgSW5jLjELMAkGA1UEBhMCVVMCEFkzVq3lWYLPREI3rN9FG1MwDQYJYIZIAWUDBAIBBQCggZUwGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcNMjAwODE3MjEzNTE2WjAqBgkqhkiG9w0BCTQxHTAbMA0GCWCGSAFlAwQCAQUAoQoGCCqGSM49BAMCMC8GCSqGSIb3DQEJBDEiBCCUQI8mMfUeOKiuhl8L0dlj-dgV1HsMguqfpYSvvnpEoDAKBggqhkjOPQQDAgRIMEYCIQD6ARULsOwE-fuAVuqNO21LciWFuDE07_0KvhByfSa-2wIhAKJnNxm3Eh6hV1DhEH7aHRdWUhtsiRc6AF2ayQkf772BAAAAAAAAaGF1dGhEYXRhWKQ55G_XcFes9vC8TnMMtLn-dO2k9aSdIb2vEJj7jXeszEAAAAAAYXBwYXR0ZXN0ZGV2ZWxvcAAgVE6UgQUJE-mMNLyJLJ8lzPDIvUYHp_Z93jIWAI2ZFXulAQIDJiABIVggd3fNlIdsxzxWx_OgvuT90jToN-8SDNG0bqqM9Lkk5EgiWCBW6GXPff8BZV1tDGSq7sw9FAB1poPSsgZOENL5YSdAkw");
        AttestationObject attestationObject = attestationObjectConverter.convert(attestationObjectBytes);
        Set transports = Collections.emptySet();
        AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs = new AuthenticationExtensionsClientOutputs();
        Instant timestamp = Instant.parse("2020-08-18T13:37:00");
        return new CoreRegistrationObject(attestationObject, attestationObjectBytes, clientDataHash, (CoreServerProperty)TestDataUtil.createServerProperty(), timestamp);
    }

    public static RegistrationObject createRegistrationObjectWithTPMAttestation() {
        byte[] collectedClientDataBytes = Base64UrlUtil.decode((String)"ew0KCSJ0eXBlIiA6ICJ3ZWJhdXRobi5jcmVhdGUiLA0KCSJjaGFsbGVuZ2UiIDogIndrNkxxRVhBTUFacHFjVFlsWTJ5b3I1RGppeUlfYjFneTluRE90Q0IxeUdZbm1fNFdHNFVrMjRGQXI3QXhUT0ZmUU1laWdrUnhPVExaTnJMeEN2Vl9RIiwNCgkib3JpZ2luIiA6ICJodHRwczovL3dlYmF1dGhuLm9yZyIsDQoJInRva2VuQmluZGluZyIgOiANCgl7DQoJCSJzdGF0dXMiIDogInN1cHBvcnRlZCINCgl9DQp9");
        CollectedClientData collectedClientData = collectedClientDataConverter.convert(collectedClientDataBytes);
        byte[] attestationObjectBytes = Base64UrlUtil.decode((String)"o2NmbXRjdHBtaGF1dGhEYXRhWQFnlWkIjx7O4yMpVANdvRDXyuORMFonUbVZu4_Xy7IpvdRFAAAAAAiYcFjK3EuBtuEw3lDcvpYAIIVs3RYj2zjEOSjQbDIbPmXofBdIkx6x-t2CpK8SRYI0pAEDAzkBACBZAQDF2m9Nk1e94gL1xVjNCjFW0lTy4K2atXkx-YJrdH3hrE8p1gcIdNzleRDhmERJnY5CRwM5sXDQIrUBq4jpwvTtMC5HGccN6-iEJAPtm9_CJzCmGhtw9hbF8bcAys94RhN9xLLUaajhWqtPrYZXCEAi0o9E2QdTIxJrcAfJgZOf33JMr0--R1BAQxpOoGRDC8ss-tfQW9ufZLWw4JUuz4Z5Jz1sbfqBYB8UUDMWoT0HgsMaPmvd7T17xGvB-pvvDf-Dt96vFGtYLEZEgho8Yu26pr5CK_BOQ-2vX9N4MIYVPXNhogMGGmKYqybhM3yhye0GdBpZBUd5iOcgME6uGJ1_IUMBAAFnYXR0U3RtdKZjdmVyYzIuMGNhbGc5__5jc2lnWQEAcV1izWGUWIs0DEOZNQGdriNNXo6nbrGDLzEAeswCK9njYGCLmOkHVgSyafhsjCEMZkQmuPUmEOMDKosqxup_tiXQwG4yCW9TyWoINWGayQ4vcr6Ys-l6KMPkg__d2VywhfonnTJDBfE_4BIRD60GR0qBzTarthDHQFMqRtoUtuOsTF5jedU3EQPojRA5iCNC2naCCZuMSURdlPmhlW5rAaRZVF41ZZECi5iFOM2rO0UpGuQSLUvr1MqQOsDytMf7qWZMvwT_5_8BF6GNdB2l2VzmIJBbV6g8z7dj0fRkjlCXBp8UG2LvTq5SsfugrRWXOJ8BkdMplPfl0mz6ssU_n2N4NWOCWQS2MIIEsjCCA5qgAwIBAgIQEyidpWZzRxOSMNfrAvV1fzANBgkqhkiG9w0BAQsFADBBMT8wPQYDVQQDEzZOQ1UtTlRDLUtFWUlELTE1OTFENEI2RUFGOThEMDEwNDg2NEI2OTAzQTQ4REQwMDI2MDc3RDMwHhcNMTgwNTIwMTYyMDQ0WhcNMjgwNTIwMTYyMDQ0WjAAMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvQ6XK2ujM11E7x4SL34p252ncyQTd3-4r5ALQhBbFKS95gUsuENTG-48GBQwu48i06cckm3eH20TUeJvn4-pj6i8LFOrIK14T3P3GFzbxgQLq1KVm63JWDdEXk789JgzQjHNO7DZFKWTEiktwmBUPUA88TjQcXOtrR5EXTrt1FzGzabOepFann3Ny_XtxI8lDZ3QLwPLJfmk7puGtkGNaXOsRC7GLAnoEB7UWvjiyKG6HAtvVTgxcW5OQnHFb9AHycU5QdukXrP0njdCpLCRR0Nq6VMKmVU3MaGh-DCwYEB32sPNPdDkPDWyk16ItwcmXqfSBV5ZOr8ifvcXbCWUWwIDAQABo4IB5TCCAeEwDgYDVR0PAQH_BAQDAgeAMAwGA1UdEwEB_wQCMAAwbQYDVR0gAQH_BGMwYTBfBgkrBgEEAYI3FR8wUjBQBggrBgEFBQcCAjBEHkIAVABDAFAAQQAgACAAVAByAHUAcwB0AGUAZAAgACAAUABsAGEAdABmAG8AcgBtACAAIABJAGQAZQBuAHQAaQB0AHkwEAYDVR0lBAkwBwYFZ4EFCAMwSgYDVR0RAQH_BEAwPqQ8MDoxODAOBgVngQUCAwwFaWQ6MTMwEAYFZ4EFAgIMB05QQ1Q2eHgwFAYFZ4EFAgEMC2lkOjRFNTQ0MzAwMB8GA1UdIwQYMBaAFMISqVvO-lb4wMFvsVvdAzRHs3qjMB0GA1UdDgQWBBSv4kXTSA8i3NUM0q57lrWpM8p_4TCBswYIKwYBBQUHAQEEgaYwgaMwgaAGCCsGAQUFBzAChoGTaHR0cHM6Ly9hemNzcHJvZG5jdWFpa3B1Ymxpc2guYmxvYi5jb3JlLndpbmRvd3MubmV0L25jdS1udGMta2V5aWQtMTU5MWQ0YjZlYWY5OGQwMTA0ODY0YjY5MDNhNDhkZDAwMjYwNzdkMy8zYjkxOGFlNC0wN2UxLTQwNTktOTQ5MS0wYWQyNDgxOTA4MTguY2VyMA0GCSqGSIb3DQEBCwUAA4IBAQAs-vqdkDX09fNNYqzbv3Lh0vl6RgGpPGl-MYgO8Lg1I9UKvEUaaUHm845ABS8m7r9p22RCWO6TSEPS0YUYzAsNuiKiGVna4nB9JWZaV9GDS6aMD0nJ8kNciorDsV60j0Yb592kv1VkOKlbTF7-Z10jaapx0CqhxEIUzEBb8y9Pa8oOaQf8ORhDHZp-mbn_W8rUzXSDS0rFbWKaW4tGpVoKGRH-f9vIeXxGlxVS0wqqRm_r-h1aZInta0OOiL_S4367gZyeLL3eUnzdd-eYySYn2XINPbVacK8ZifdsLMwiNtz5uM1jbqpEn2UoB3Hcdn0hc12jTLPWFfg7GiKQ0hk9WQXsMIIF6DCCA9CgAwIBAgITMwAAAQDiBsSROVGXhwAAAAABADANBgkqhkiG9w0BAQsFADCBjDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjE2MDQGA1UEAxMtTWljcm9zb2Z0IFRQTSBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAyMDE0MB4XDTE3MDIwMTE3NDAyNFoXDTI5MTIzMTE3NDAyNFowQTE_MD0GA1UEAxM2TkNVLU5UQy1LRVlJRC0xNTkxRDRCNkVBRjk4RDAxMDQ4NjRCNjkwM0E0OEREMDAyNjA3N0QzMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA9IwUMSiQUbrQR0NLkKR-9RB8zfHYdlmDB0XN_m8qrNHKRJ__lBOR-mwU_h3MFRZF6X3ZZwka1DtwBdzLFV8lVu33bc15stjSd6B22HRRKQ3sIns5AYQxg0eX2PtWCJuIhxdM_jDjP2hq9Yvx-ibt1IO9UZwj83NGxXc7Gk2UvCs9lcFSp6U8zzl5fGFCKYcxIKH0qbPrzjlyVyZTKwGGSTeoMMEdsZiq-m_xIcrehYuHg-FAVaPLLTblS1h5cu80-ruFUm5Xzl61YjVU9tAV_Y4joAsJ5QP3VPocFhr5YVsBVYBiBcQtr5JFdJXZWWEgYcFLdAFUk8nJERS7-5xLuQIDAQABo4IBizCCAYcwCwYDVR0PBAQDAgGGMBsGA1UdJQQUMBIGCSsGAQQBgjcVJAYFZ4EFCAMwFgYDVR0gBA8wDTALBgkrBgEEAYI3FR8wEgYDVR0TAQH_BAgwBgEB_wIBADAdBgNVHQ4EFgQUwhKpW876VvjAwW-xW90DNEezeqMwHwYDVR0jBBgwFoAUeowKzi9IYhfilNGuVcFS7HF0pFYwcAYDVR0fBGkwZzBloGOgYYZfaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraW9wcy9jcmwvTWljcm9zb2Z0JTIwVFBNJTIwUm9vdCUyMENlcnRpZmljYXRlJTIwQXV0aG9yaXR5JTIwMjAxNC5jcmwwfQYIKwYBBQUHAQEEcTBvMG0GCCsGAQUFBzAChmFodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NlcnRzL01pY3Jvc29mdCUyMFRQTSUyMFJvb3QlMjBDZXJ0aWZpY2F0ZSUyMEF1dGhvcml0eSUyMDIwMTQuY3J0MA0GCSqGSIb3DQEBCwUAA4ICAQAKc9z1UUBAaybIVnK8yL1N1iGJFFFFw_PpkxW76hgQhUcCxNFQskfahfFzkBD05odVC1DKyk2PyOle0G86FCmZiJa14MtKNsiu66nVqk2hr8iIcu-cYEsgb446yIGd1NblQKA1C_28F2KHm8YRgcFtRSkWEMuDiVMa0HDU8aI6ZHO04Naj86nXeULJSZsA0pQwNJ04-QJP3MFQzxQ7md6D-pCx-LVA-WUdGxT1ofaO5NFxq0XjubnZwRjQazy_m93dKWp19tbBzTUKImgUKLYGcdmVWXAxUrkxHN2FbZGOYWfmE2TGQXS2Z-g4YAQo1PleyOav3HNB8ti7u5HpI3t9a73xuECy2gFcZQ24DJuBaQe4mU5I_hPiAa-822nPPL6w8m1eegxhHf7ziRW_hW8s1cvAZZ5Jpev96zL_zRv34MsRWhKwLbu2oOCSEYYh8D8DbQZjmsxlUYR_q1cP8JKiIo6NNJ85g7sjTZgXxeanA9wZwqwJB-P98VdVslC17PmVu0RHOqRtxrht7OFT7Z10ecz0tj9ODXrv5nmBktmbgHRirRMl84wp7-PJhTXdHbxZv-OoL4HP6FxyDbHxLB7QmR4-VoEZN0vsybb1A8KEj2pkNY_tmxHH6k87euM99bB8FHrW9FNrXCGL1p6-PYtiky52a5YQZGT8Hz-ZnxobTmhjZXJ0SW5mb1ih_1RDR4AXACIAC7xZ9N_ZpqQtw7hmr_LfDRmCa78BS2erCtbrsXYwa4AHABSsnz8FacZi-wkUkfHu4xjG8MPfmwAAAAGxWkjHaED549jznwUBqeDEpT-7xBMAIgALcSGuv6a5r9BwMvQvCSXg7GdAjdWZpXv6D4DH8VYBCE8AIgALAVI0eQ_AAZjNvrhUEMK2q4wxuwIFOnHIDF0Qljhf47RncHViQXJlYVkBNgABAAsABgRyACCd_8vzbDg65pn7mGjcbcuJ1xU4hL4oA5IsEkFYv60irgAQABAIAAAAAAABAMXab02TV73iAvXFWM0KMVbSVPLgrZq1eTH5gmt0feGsTynWBwh03OV5EOGYREmdjkJHAzmxcNAitQGriOnC9O0wLkcZxw3r6IQkA-2b38InMKYaG3D2FsXxtwDKz3hGE33EstRpqOFaq0-thlcIQCLSj0TZB1MjEmtwB8mBk5_fckyvT75HUEBDGk6gZEMLyyz619Bb259ktbDglS7PhnknPWxt-oFgHxRQMxahPQeCwxo-a93tPXvEa8H6m-8N_4O33q8Ua1gsRkSCGjxi7bqmvkIr8E5D7a9f03gwhhU9c2GiAwYaYpirJuEzfKHJ7QZ0GlkFR3mI5yAwTq4YnX8");
        AttestationObject attestationObject = attestationObjectConverter.convert(attestationObjectBytes);
        Set transports = Collections.emptySet();
        AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs = new AuthenticationExtensionsClientOutputs();
        return new RegistrationObject(attestationObject, attestationObjectBytes, collectedClientData, collectedClientDataBytes, authenticationExtensionsClientOutputs, transports, TestDataUtil.createServerProperty());
    }

    public static RegistrationObject createRegistrationObjectWithAppleAttestation() {
        byte[] collectedClientDataBytes = Base64UrlUtil.decode((String)"eyJ0eXBlIjoid2ViYXV0aG4uY3JlYXRlIiwiY2hhbGxlbmdlIjoia093TXZFMm1RTzZvdTBCMGpqRDBWQSIsIm9yaWdpbiI6Imh0dHBzOi8vNmNjM2M5ZTc5NjdhLm5ncm9rLmlvIn0");
        CollectedClientData collectedClientData = collectedClientDataConverter.convert(collectedClientDataBytes);
        byte[] attestationObjectBytes = Base64UrlUtil.decode((String)"o2NmbXRlYXBwbGVnYXR0U3RtdKJjYWxnJmN4NWOCWQJIMIICRDCCAcmgAwIBAgIGAXUCfWGDMAoGCCqGSM49BAMCMEgxHDAaBgNVBAMME0FwcGxlIFdlYkF1dGhuIENBIDExEzARBgNVBAoMCkFwcGxlIEluYy4xEzARBgNVBAgMCkNhbGlmb3JuaWEwHhcNMjAxMDA3MDk0NjEyWhcNMjAxMDA4MDk1NjEyWjCBkTFJMEcGA1UEAwxANjEyNzZmYzAyZDNmZThkMTZiMzNiNTU0OWQ4MTkyMzZjODE3NDZhODNmMmU5NGE2ZTRiZWUxYzcwZjgxYjViYzEaMBgGA1UECwwRQUFBIENlcnRpZmljYXRpb24xEzARBgNVBAoMCkFwcGxlIEluYy4xEzARBgNVBAgMCkNhbGlmb3JuaWEwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAR5_lkIu1EpyAk4t1TATSs0DvpmFbmHaYv1naTlPqPm_vsD2qEnDVgE6KthwVqsokNcfb82nXHKFcUjsABKG3W3o1UwUzAMBgNVHRMBAf8EAjAAMA4GA1UdDwEB_wQEAwIE8DAzBgkqhkiG92NkCAIEJjAkoSIEIJxgAhVAs-GYNN_jfsYkRcieGylPeSzka5QTwyMO84aBMAoGCCqGSM49BAMCA2kAMGYCMQDaHBjrI75xAF7SXzyF5zSQB_Lg9PjTdyye-w7stiqy84K6lmo8d3fIptYjLQx81bsCMQCvC8MSN-aewiaU0bMsdxRbdDerCJJj3xJb3KZwloevJ3daCmCcrZrAPYfLp2kDOshZAjgwggI0MIIBuqADAgECAhBWJVOVx6f7QOviKNgmCFO2MAoGCCqGSM49BAMDMEsxHzAdBgNVBAMMFkFwcGxlIFdlYkF1dGhuIFJvb3QgQ0ExEzARBgNVBAoMCkFwcGxlIEluYy4xEzARBgNVBAgMCkNhbGlmb3JuaWEwHhcNMjAwMzE4MTgzODAxWhcNMzAwMzEzMDAwMDAwWjBIMRwwGgYDVQQDDBNBcHBsZSBXZWJBdXRobiBDQSAxMRMwEQYDVQQKDApBcHBsZSBJbmMuMRMwEQYDVQQIDApDYWxpZm9ybmlhMHYwEAYHKoZIzj0CAQYFK4EEACIDYgAEgy6HLyYUkYECJbn1_Na7Y3i19V8_ywRbxzWZNHX9VJBE35v-GSEXZcaaHdoFCzjUUINAGkNPsk0RLVbD4c-_y5iR_sBpYIG--Wy8d8iN3a9Gpa7h3VFbWvqrk76cCyaRo2YwZDASBgNVHRMBAf8ECDAGAQH_AgEAMB8GA1UdIwQYMBaAFCbXZNnFeMJaZ9Gn3msS0Btj8cbXMB0GA1UdDgQWBBTrroLE_6GsW1HUzyRhBQC-Y713iDAOBgNVHQ8BAf8EBAMCAQYwCgYIKoZIzj0EAwMDaAAwZQIxAN2LGjSBpfrZ27TnZXuEHhRMJ7dbh2pBhsKxR1dQM3In7-VURX72SJUMYy5cSD5wwQIwLIpgRNwgH8_lm8NNKTDBSHhR2WDtanXx60rKvjjNJbiX0MgFvvDH94sHpXHG6A4HaGF1dGhEYXRhWJhWHo8_bWPQzAMKYRIrGXu__PkMUfuqHM4RH7Jea4WDgkUAAAAAAAAAAAAAAAAAAAAAAAAAAAAUomGfdaNI-cYgWrq2klNk97zkcg-lAQIDJiABIVggef5ZCLtRKcgJOLdUwE0rNA76ZhW5h2mL9Z2k5T6j5v4iWCD7A9qhJw1YBOirYcFarKJDXH2_Np1xyhXFI7AASht1tw");
        AttestationObject attestationObject = attestationObjectConverter.convert(attestationObjectBytes);
        Set transports = Collections.emptySet();
        AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs = new AuthenticationExtensionsClientOutputs();
        ServerProperty serverProperty = new ServerProperty(new Origin("https://6cc3c9e7967a.ngrok.io"), "6cc3c9e7967a.ngrok.io", (Challenge)new DefaultChallenge("kOwMvE2mQO6ou0B0jjD0VA"), null);
        return new RegistrationObject(attestationObject, attestationObjectBytes, collectedClientData, collectedClientDataBytes, authenticationExtensionsClientOutputs, transports, serverProperty, Instant.parse("2020-10-07T10:00:00Z"));
    }

    public static RegistrationObject createRegistrationObject(Function<byte[], AttestationObject> attestationObjectProvider) {
        CollectedClientData collectedClientData = TestDataUtil.createClientData(ClientDataType.WEBAUTHN_CREATE);
        byte[] collectedClientDataBytes = collectedClientDataConverter.convertToBytes(collectedClientData);
        AttestationObject attestationObject = attestationObjectProvider.apply(collectedClientDataBytes);
        byte[] attestationObjectBytes = attestationObjectConverter.convertToBytes(attestationObject);
        Set transports = Collections.emptySet();
        AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs = new AuthenticationExtensionsClientOutputs();
        return new RegistrationObject(attestationObject, attestationObjectBytes, collectedClientData, collectedClientDataBytes, authenticationExtensionsClientOutputs, transports, TestDataUtil.createServerProperty());
    }

    public static RegistrationObject createRegistrationObject(PublicKeyCredential<AuthenticatorAttestationResponse, RegistrationExtensionClientOutput> publicKeyCredential) {
        AuthenticatorAttestationResponse registrationRequest = (AuthenticatorAttestationResponse)publicKeyCredential.getResponse();
        byte[] attestationObjectBytes = ((AuthenticatorAttestationResponse)publicKeyCredential.getResponse()).getAttestationObject();
        CollectedClientData collectedClientData = collectedClientDataConverter.convert(registrationRequest.getClientDataJSON());
        AuthenticationExtensionsClientOutputs clientExtensionResults = publicKeyCredential.getClientExtensionResults();
        Set transports = ((AuthenticatorAttestationResponse)publicKeyCredential.getResponse()).getTransports();
        AttestationObject attestationObject = attestationObjectConverter.convert(attestationObjectBytes);
        return new RegistrationObject(attestationObject, attestationObjectBytes, collectedClientData, registrationRequest.getClientDataJSON(), clientExtensionResults, transports, TestDataUtil.createServerProperty());
    }

    public static AttestationObject createAttestationObjectWithFIDOU2FAttestationStatement() {
        return new AttestationObject(TestDataUtil.createAuthenticatorData(), (AttestationStatement)TestAttestationStatementUtil.createFIDOU2FAttestationStatement());
    }

    public static AttestationObject createAttestationObjectWithBasicPackedECAttestationStatement(byte[] clientDataHash) {
        PrivateKey privateKey = TestAttestationUtil.load3tierTestAuthenticatorAttestationPrivateKey();
        return TestDataUtil.createAttestationObject(clientDataHash, privateKey, signature -> TestAttestationStatementUtil.createBasicPackedAttestationStatement(COSEAlgorithmIdentifier.ES256, signature));
    }

    public static AttestationObject createAttestationObjectWithSelfPackedECAttestationStatement(byte[] clientDataHash) {
        KeyPair keyPair = ECUtil.createKeyPair();
        EC2COSEKey ec2CredentialPublicKey = EC2COSEKey.create((ECPublicKey)((ECPublicKey)keyPair.getPublic()), (COSEAlgorithmIdentifier)COSEAlgorithmIdentifier.ES256);
        AuthenticatorData authenticatorData = TestDataUtil.createAuthenticatorData((COSEKey)ec2CredentialPublicKey);
        byte[] authenticatorDataBytes = authenticatorDataConverter.convert(authenticatorData);
        byte[] signedData = TestDataUtil.createSignedData(authenticatorDataBytes, clientDataHash);
        byte[] signature = TestDataUtil.calculateSignature(keyPair.getPrivate(), signedData);
        return new AttestationObject(authenticatorData, (AttestationStatement)TestAttestationStatementUtil.createSelfPackedAttestationStatement(COSEAlgorithmIdentifier.ES256, signature));
    }

    public static AttestationObject createAttestationObjectWithSelfPackedRSAAttestationStatement(byte[] clientDataHash) {
        KeyPair keyPair = RSAUtil.createKeyPair();
        RSACOSEKey rsaCredentialPublicKey = RSACOSEKey.create((RSAPublicKey)((RSAPublicKey)keyPair.getPublic()), (COSEAlgorithmIdentifier)COSEAlgorithmIdentifier.RS256);
        AuthenticatorData authenticatorData = TestDataUtil.createAuthenticatorData((COSEKey)rsaCredentialPublicKey);
        byte[] authenticatorDataBytes = authenticatorDataConverter.convert(authenticatorData);
        byte[] signedData = TestDataUtil.createSignedData(authenticatorDataBytes, clientDataHash);
        byte[] signature = TestDataUtil.calculateSignature(keyPair.getPrivate(), signedData);
        return new AttestationObject(authenticatorData, (AttestationStatement)TestAttestationStatementUtil.createSelfPackedAttestationStatement(COSEAlgorithmIdentifier.RS256, signature));
    }

    public static AttestationObject createAttestationObjectWithAndroidKeyAttestationStatement(byte[] clientDataHash) {
        PrivateKey privateKey = TestAttestationUtil.load3tierTestAuthenticatorAttestationPrivateKey();
        return TestDataUtil.createAttestationObject(clientDataHash, privateKey, signature -> TestAttestationStatementUtil.createAndroidKeyAttestationStatement(COSEAlgorithmIdentifier.ES256, signature));
    }

    public static AttestationObject createAttestationObject(byte[] clientDataHash, PrivateKey attestationPrivateKey, Function<byte[], AttestationStatement> attestationStatementProvider) {
        AuthenticatorData authenticatorData = TestDataUtil.createAuthenticatorData();
        byte[] authenticatorDataBytes = authenticatorDataConverter.convert(authenticatorData);
        byte[] signedData = TestDataUtil.createSignedData(authenticatorDataBytes, clientDataHash);
        byte[] signature = TestDataUtil.calculateSignature(attestationPrivateKey, signedData);
        return new AttestationObject(authenticatorData, attestationStatementProvider.apply(signature));
    }

    public static AttestationObject createAttestationObject(AttestationStatement attestationStatement) {
        AuthenticatorData authenticatorData = TestDataUtil.createAuthenticatorData();
        return new AttestationObject(authenticatorData, attestationStatement);
    }

    private static byte[] createSignedData(byte[] authenticatorData, byte[] clientDataHash) {
        return ByteBuffer.allocate(authenticatorData.length + clientDataHash.length).put(authenticatorData).put(clientDataHash).array();
    }

    public static <T extends ExtensionAuthenticatorOutput> AuthenticatorData<T> createAuthenticatorData() {
        byte flags = 65;
        return new AuthenticatorData(new byte[32], flags, 1L, TestDataUtil.createAttestedCredentialData());
    }

    public static <T extends RegistrationExtensionAuthenticatorOutput> AuthenticatorData<T> createAuthenticatorData(COSEKey coseKey) {
        byte flags = 65;
        return new AuthenticatorData(new byte[32], flags, 1L, TestDataUtil.createAttestedCredentialData(coseKey));
    }

    public static AttestedCredentialData createAttestedCredentialData() {
        return TestDataUtil.createAttestedCredentialData((COSEKey)TestDataUtil.createEC2COSEPublicKey());
    }

    public static AttestedCredentialData createAttestedCredentialData(COSEKey coseKey) {
        return new AttestedCredentialData(AAGUID.ZERO, new byte[32], coseKey);
    }

    public static EC2COSEKey createEC2COSEPublicKey() {
        return new EC2COSEKey(null, COSEAlgorithmIdentifier.ES256, null, Curve.SECP256R1, new byte[32], new byte[32]);
    }

    public static RSACOSEKey createRSACOSEPublicKey() {
        RSACOSEKey credentialPublicKey = new RSACOSEKey(null, COSEAlgorithmIdentifier.RS256, null, new byte[32], new byte[32]);
        return credentialPublicKey;
    }

    public static EC2COSEKey createEC2COSEPublicKey(ECPublicKey publicKey) {
        return TestDataUtil.createEC2COSEKey(publicKey, null);
    }

    public static EC2COSEKey createEC2COSEPrivateKey(ECPublicKey publicKey, ECPrivateKey privateKey) {
        return TestDataUtil.createEC2COSEKey(publicKey, privateKey.getS());
    }

    private static EC2COSEKey createEC2COSEKey(ECPublicKey publicKey, BigInteger d) {
        COSEAlgorithmIdentifier coseAlgorithmIdentifier;
        Curve curve;
        ECPoint ecPoint = publicKey.getW();
        EllipticCurve ellipticCurve = publicKey.getParams().getCurve();
        switch (ellipticCurve.getField().getFieldSize()) {
            case 256: {
                curve = Curve.SECP256R1;
                coseAlgorithmIdentifier = COSEAlgorithmIdentifier.ES256;
                break;
            }
            case 384: {
                curve = Curve.SECP384R1;
                coseAlgorithmIdentifier = COSEAlgorithmIdentifier.ES384;
                break;
            }
            case 521: {
                curve = Curve.SECP521R1;
                coseAlgorithmIdentifier = COSEAlgorithmIdentifier.ES512;
                break;
            }
            default: {
                throw new IllegalStateException("We can only support secp256r1, secp384r1 or secp521r1");
            }
        }
        byte[] x = ArrayUtil.convertToFixedByteArray((int)curve.getSize(), (BigInteger)ecPoint.getAffineX());
        byte[] y = ArrayUtil.convertToFixedByteArray((int)curve.getSize(), (BigInteger)ecPoint.getAffineY());
        return new EC2COSEKey(null, coseAlgorithmIdentifier, null, curve, x, y, d == null ? null : d.toByteArray());
    }

    public static CollectedClientData createClientData(ClientDataType type) {
        return TestDataUtil.createClientData(type, TestDataUtil.createChallenge());
    }

    public static CollectedClientData createClientData(ClientDataType type, Challenge challenge) {
        return new CollectedClientData(type, challenge, TestDataUtil.createOrigin(), null);
    }

    public static byte[] createClientDataJSON(ClientDataType type) {
        return collectedClientDataConverter.convertToBytes(TestDataUtil.createClientData(type));
    }

    public static byte[] createClientDataJSON(ClientDataType type, Challenge challenge) {
        return collectedClientDataConverter.convertToBytes(TestDataUtil.createClientData(type, challenge));
    }

    public static Challenge createChallenge() {
        UUID uuid = UUID.randomUUID();
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        byte[] challengeValue = ByteBuffer.allocate(16).putLong(hi).putLong(lo).array();
        return new DefaultChallenge(challengeValue);
    }

    public static Origin createOrigin() {
        return new Origin("https://localhost:8080");
    }

    public static ServerProperty createRelyingParty() {
        return new ServerProperty(TestDataUtil.createOrigin(), "localhost", TestDataUtil.createChallenge(), null);
    }

    public static Authenticator createAuthenticator(AttestationObject attestationObject) {
        AttestedCredentialData attestedCredentialData = attestationObject.getAuthenticatorData().getAttestedCredentialData();
        return new AuthenticatorImpl(attestedCredentialData, attestationObject.getAttestationStatement(), attestationObject.getAuthenticatorData().getSignCount());
    }

    public static ServerProperty createServerProperty() {
        return TestDataUtil.createServerProperty(TestDataUtil.createChallenge());
    }

    public static ServerProperty createServerProperty(Challenge challenge) {
        return new ServerProperty(TestDataUtil.createOrigin(), "example.com", challenge, new byte[32]);
    }

    public static Authenticator createAuthenticator(AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement) {
        return new AuthenticatorImpl(attestedCredentialData, attestationStatement, 1L);
    }

    public static Authenticator createAuthenticator() {
        return TestDataUtil.createAuthenticator(TestDataUtil.createAttestedCredentialData(), (AttestationStatement)TestAttestationStatementUtil.createFIDOU2FAttestationStatement());
    }

    public static byte[] calculateSignature(PrivateKey privateKey, byte[] signedData) {
        try {
            Signature signature = privateKey.getAlgorithm().equals("EC") ? SignatureUtil.createES256() : SignatureUtil.createRS256();
            signature.initSign(privateKey);
            signature.update(signedData);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new WebAuthnModelException("Signature calculation error", e);
        }
    }

    static {
        ObjectMapper jsonMapper = new ObjectMapper();
        ObjectMapper cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
        cborMapper.registerModule((Module)new DeviceCheckCBORModule());
        objectConverter = new ObjectConverter(jsonMapper, cborMapper);
        collectedClientDataConverter = new CollectedClientDataConverter(objectConverter);
        attestationObjectConverter = new AttestationObjectConverter(objectConverter);
        authenticatorDataConverter = new AuthenticatorDataConverter(objectConverter);
    }
}

