/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.u2f;

import com.webauthn4j.test.authenticator.u2f.exception.FIDOU2FException;
import com.webauthn4j.util.WIP;
import java.nio.ByteBuffer;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

@WIP
public class RegistrationResponse {
    private static final byte RESERVED_BYTE = 5;
    private byte reservedByte;
    private byte[] userPublicKey;
    private byte[] keyHandle;
    private X509Certificate attestationCertificate;
    private byte[] signature;

    public RegistrationResponse(byte reservedByte, byte[] userPublicKey, byte[] keyHandle, X509Certificate attestationCertificate, byte[] signature) {
        if (userPublicKey.length != 65) {
            throw new IllegalArgumentException("userPublicKey must be 65 bytes");
        }
        if (keyHandle.length > 255) {
            throw new IllegalArgumentException("keyHandle length must not exceed 255 bytes");
        }
        this.reservedByte = reservedByte;
        this.userPublicKey = userPublicKey;
        this.keyHandle = keyHandle;
        this.attestationCertificate = attestationCertificate;
        this.signature = signature;
    }

    public RegistrationResponse(byte[] userPublicKey, byte[] keyHandle, X509Certificate attestationCertificate, byte[] signature) {
        this(5, userPublicKey, keyHandle, attestationCertificate, signature);
    }

    public byte getReservedByte() {
        return this.reservedByte;
    }

    public byte[] getUserPublicKey() {
        return this.userPublicKey;
    }

    public byte[] getKeyHandle() {
        return this.keyHandle;
    }

    public X509Certificate getAttestationCertificate() {
        return this.attestationCertificate;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getBytes() {
        try {
            byte keyHandleLength = (byte)this.keyHandle.length;
            byte[] attestationCertificateBytes = this.attestationCertificate.getEncoded();
            return ByteBuffer.allocate(67 + this.keyHandle.length + attestationCertificateBytes.length + this.signature.length).put(this.reservedByte).put(this.userPublicKey).put(keyHandleLength).put(this.keyHandle).put(attestationCertificateBytes).put(this.signature).array();
        }
        catch (CertificateEncodingException e) {
            throw new FIDOU2FException(e);
        }
    }
}

