/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.webauthn;

import com.webauthn4j.data.PublicKeyCredentialDescriptor;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.PublicKeyCredentialRpEntity;
import com.webauthn4j.data.PublicKeyCredentialUserEntity;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.util.AssertUtil;
import java.util.Collections;
import java.util.List;

public class MakeCredentialRequest {
    private byte[] hash;
    private PublicKeyCredentialRpEntity rpEntity;
    private PublicKeyCredentialUserEntity userEntity;
    private boolean requireResidentKey;
    private boolean requireUserPresence;
    private boolean requireUserVerification;
    private List<PublicKeyCredentialParameters> credTypesAndPublicKeyAlgs;
    private List<PublicKeyCredentialDescriptor> excludeCredentialDescriptorList;
    private AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions;

    public MakeCredentialRequest(byte[] hash, PublicKeyCredentialRpEntity rpEntity, PublicKeyCredentialUserEntity userEntity, boolean requireResidentKey, boolean requireUserPresence, boolean requireUserVerification, List<PublicKeyCredentialParameters> credTypesAndPublicKeyAlgs, List<PublicKeyCredentialDescriptor> excludeCredentialDescriptorList, AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions) {
        AssertUtil.notNull(credTypesAndPublicKeyAlgs, (String)"credTypesAndPublicKeyAlgs must not be null");
        this.hash = hash;
        this.rpEntity = rpEntity;
        this.userEntity = userEntity;
        this.requireResidentKey = requireResidentKey;
        this.requireUserPresence = requireUserPresence;
        this.requireUserVerification = requireUserVerification;
        this.credTypesAndPublicKeyAlgs = credTypesAndPublicKeyAlgs;
        this.excludeCredentialDescriptorList = excludeCredentialDescriptorList;
        this.extensions = extensions;
    }

    public MakeCredentialRequest(byte[] hash, PublicKeyCredentialRpEntity rpEntity, PublicKeyCredentialUserEntity userEntity, boolean requireResidentKey, boolean requireUserPresence, boolean requireUserVerification, List<PublicKeyCredentialParameters> credTypesAndPublicKeyAlgs, List<PublicKeyCredentialDescriptor> excludeCredentialDescriptorList) {
        this(hash, rpEntity, userEntity, requireResidentKey, requireUserPresence, requireUserVerification, credTypesAndPublicKeyAlgs, excludeCredentialDescriptorList, (AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput>)new AuthenticationExtensionsClientInputs());
    }

    public MakeCredentialRequest(byte[] hash, PublicKeyCredentialRpEntity rpEntity, PublicKeyCredentialUserEntity userEntity, boolean requireResidentKey, boolean requireUserPresence, boolean requireUserVerification, List<PublicKeyCredentialParameters> credTypesAndPublicKeyAlgs) {
        this(hash, rpEntity, userEntity, requireResidentKey, requireUserPresence, requireUserVerification, credTypesAndPublicKeyAlgs, Collections.emptyList(), (AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput>)new AuthenticationExtensionsClientInputs());
    }

    public byte[] getHash() {
        return this.hash;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public PublicKeyCredentialRpEntity getRpEntity() {
        return this.rpEntity;
    }

    public void setRpEntity(PublicKeyCredentialRpEntity rpEntity) {
        this.rpEntity = rpEntity;
    }

    public PublicKeyCredentialUserEntity getUserEntity() {
        return this.userEntity;
    }

    public void setUserEntity(PublicKeyCredentialUserEntity userEntity) {
        this.userEntity = userEntity;
    }

    public boolean isRequireResidentKey() {
        return this.requireResidentKey;
    }

    public void setRequireResidentKey(boolean requireResidentKey) {
        this.requireResidentKey = requireResidentKey;
    }

    public boolean isRequireUserPresence() {
        return this.requireUserPresence;
    }

    public void setRequireUserPresence(boolean requireUserPresence) {
        this.requireUserPresence = requireUserPresence;
    }

    public boolean isRequireUserVerification() {
        return this.requireUserVerification;
    }

    public void setRequireUserVerification(boolean requireUserVerification) {
        this.requireUserVerification = requireUserVerification;
    }

    public List<PublicKeyCredentialParameters> getCredTypesAndPublicKeyAlgs() {
        return this.credTypesAndPublicKeyAlgs;
    }

    public void setCredTypesAndPublicKeyAlgs(List<PublicKeyCredentialParameters> credTypesAndPublicKeyAlgs) {
        AssertUtil.notNull(credTypesAndPublicKeyAlgs, (String)"credTypesAndPublicKeyAlgs must not be null");
        this.credTypesAndPublicKeyAlgs = credTypesAndPublicKeyAlgs;
    }

    public List<PublicKeyCredentialDescriptor> getExcludeCredentialDescriptorList() {
        return this.excludeCredentialDescriptorList;
    }

    public void setExcludeCredentialDescriptorList(List<PublicKeyCredentialDescriptor> excludeCredentialDescriptorList) {
        this.excludeCredentialDescriptorList = excludeCredentialDescriptorList;
    }

    public AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions) {
        this.extensions = extensions;
    }
}

