/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test;

import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Date;
import java.time.Instant;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class AttestationCertificateBuilder {
    private final X509v3CertificateBuilder certificateBuilder;

    public AttestationCertificateBuilder(X509Certificate issuerCertificate, X500Principal subject, PublicKey publicKey) {
        this.certificateBuilder = new JcaX509v3CertificateBuilder(issuerCertificate, BigInteger.valueOf(1L), Date.from(Instant.parse("2000-01-01T00:00:00Z")), Date.from(Instant.parse("2999-12-31T23:59:59Z")), subject, publicKey);
    }

    public void addSubjectAlternativeNamesExtension(String subjectAlternativeNames) {
        try {
            DERSequence derSequence = new DERSequence(new ASN1Encodable[]{new GeneralName(4, subjectAlternativeNames)});
            this.certificateBuilder.addExtension(Extension.subjectAlternativeName, true, (ASN1Encodable)derSequence);
        }
        catch (CertIOException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public void addBasicConstraintsExtension() {
        try {
            this.certificateBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(true));
        }
        catch (CertIOException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public void addKeyUsageExtension() {
        try {
            this.certificateBuilder.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(4));
        }
        catch (CertIOException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public void addExtendedKeyUsageExtension(KeyPurposeId keyPurposeId) {
        try {
            this.certificateBuilder.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(keyPurposeId));
        }
        catch (CertIOException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public X509Certificate build(PrivateKey issuerPrivateKey) {
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256withECDSA").build(issuerPrivateKey);
            X509CertificateHolder certificateHolder = this.certificateBuilder.build(contentSigner);
            return new JcaX509CertificateConverter().getCertificate(certificateHolder);
        }
        catch (CertificateException e) {
            throw new com.webauthn4j.validator.exception.CertificateException((Throwable)e);
        }
        catch (OperatorCreationException e) {
            throw new UnexpectedCheckedException((Throwable)e);
        }
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) {
        try {
            this.certificateBuilder.addExtension(oid, isCritical, value);
        }
        catch (CertIOException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

