/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test;

import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CipherUtil {
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final int IV_SIZE = 96;
    private static final int TAG_SIZE = 128;

    private CipherUtil() {
    }

    public static byte[] encrypt(byte[] data, byte[] encryptionKey) {
        try {
            byte[] iv = new byte[12];
            secureRandom.nextBytes(iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)new SecretKeySpec(encryptionKey, "AES"), new GCMParameterSpec(128, iv));
            byte[] cipherBytes = cipher.doFinal(data);
            byte[] output = new byte[iv.length + cipherBytes.length];
            System.arraycopy(iv, 0, output, 0, iv.length);
            System.arraycopy(cipherBytes, 0, output, iv.length, cipherBytes.length);
            return output;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new UnexpectedCheckedException((Throwable)e);
        }
    }

    public static byte[] decrypt(byte[] encrypted, byte[] encryptionKey) {
        try {
            byte[] iv = new byte[12];
            byte[] cipherBytes = new byte[encrypted.length - iv.length];
            System.arraycopy(encrypted, 0, iv, 0, iv.length);
            System.arraycopy(encrypted, iv.length, cipherBytes, 0, cipherBytes.length);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(encryptionKey, "AES"), new GCMParameterSpec(128, iv));
            return cipher.doFinal(cipherBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new UnexpectedCheckedException((Throwable)e);
        }
    }
}

