/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.config.configurers;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AttestationConveyancePreference;
import com.webauthn4j.data.AuthenticatorAttachment;
import com.webauthn4j.data.AuthenticatorSelectionCriteria;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.ResidentKeyRequirement;
import com.webauthn4j.data.UserVerificationRequirement;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.springframework.security.UserVerificationStrategy;
import com.webauthn4j.springframework.security.WebAuthnProcessingFilter;
import com.webauthn4j.springframework.security.config.configurers.WebAuthnConfigurerUtil;
import com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer;
import com.webauthn4j.springframework.security.endpoint.AssertionOptionsEndpointFilter;
import com.webauthn4j.springframework.security.endpoint.AttestationOptionsEndpointFilter;
import com.webauthn4j.springframework.security.extension.AuthenticationExtensionProvider;
import com.webauthn4j.springframework.security.extension.AuthenticationExtensionsClientInputsProvider;
import com.webauthn4j.springframework.security.extension.RegistrationExtensionProvider;
import com.webauthn4j.springframework.security.options.AssertionOptionsProvider;
import com.webauthn4j.springframework.security.options.AssertionOptionsProviderImpl;
import com.webauthn4j.springframework.security.options.AttestationOptionsProvider;
import com.webauthn4j.springframework.security.options.AttestationOptionsProviderImpl;
import com.webauthn4j.springframework.security.options.PublicKeyCredentialUserEntityProvider;
import com.webauthn4j.springframework.security.options.RpIdProvider;
import com.webauthn4j.springframework.security.server.ServerPropertyProvider;
import com.webauthn4j.springframework.security.server.ServerPropertyProviderImpl;
import jakarta.servlet.Filter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.ForwardAuthenticationFailureHandler;
import org.springframework.security.web.authentication.ForwardAuthenticationSuccessHandler;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class WebAuthnLoginConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractAuthenticationFilterConfigurer<H, WebAuthnLoginConfigurer<H>, WebAuthnProcessingFilter> {
    private RpIdProvider rpIdProvider = null;
    private ObjectConverter objectConverter = null;
    private ServerPropertyProvider serverPropertyProvider = null;
    private AuthenticationTrustResolver trustResolver = null;
    private UserVerificationStrategy userVerificationStrategy = null;
    private final AttestationOptionsEndpointConfig attestationOptionsEndpointConfig = new AttestationOptionsEndpointConfig();
    private final AssertionOptionsEndpointConfig assertionOptionsEndpointConfig = new AssertionOptionsEndpointConfig();
    private String rpId = null;
    private String usernameParameter = null;
    private String passwordParameter = null;
    private String credentialIdParameter = null;
    private String clientDataJSONParameter = null;
    private String authenticatorDataParameter = null;
    private String signatureParameter = null;
    private String clientExtensionsJSONParameter = null;

    public WebAuthnLoginConfigurer() {
        super((AbstractAuthenticationProcessingFilter)new WebAuthnProcessingFilter(), null);
    }

    public static WebAuthnLoginConfigurer<HttpSecurity> webAuthnLogin() {
        return new WebAuthnLoginConfigurer<HttpSecurity>();
    }

    public void configure(H http) {
        super.configure(http);
        if (this.objectConverter == null) {
            this.objectConverter = WebAuthnConfigurerUtil.getObjectConverterOrCreateNew(http);
        }
        http.setSharedObject(ObjectConverter.class, (Object)this.objectConverter);
        if (this.rpIdProvider == null) {
            this.rpIdProvider = WebAuthnConfigurerUtil.getRpIdProviderOrNull(http);
        }
        http.setSharedObject(RpIdProvider.class, (Object)this.rpIdProvider);
        if (this.serverPropertyProvider == null) {
            this.serverPropertyProvider = WebAuthnConfigurerUtil.getServerPropertyProviderOrCreateNew(http);
        }
        if (this.serverPropertyProvider instanceof ServerPropertyProviderImpl) {
            ServerPropertyProviderImpl serverPropertyProviderImpl = (ServerPropertyProviderImpl)this.serverPropertyProvider;
            if (this.rpId != null) {
                serverPropertyProviderImpl.setRpId(this.rpId);
            }
            if (this.rpIdProvider != null) {
                serverPropertyProviderImpl.setRpIdProvider(this.rpIdProvider);
            }
        }
        http.setSharedObject(ServerPropertyProvider.class, (Object)this.serverPropertyProvider);
        if (this.trustResolver == null) {
            this.trustResolver = WebAuthnConfigurerUtil.getAuthenticationTrustResolverOrCreateNew(http);
        }
        http.setSharedObject(AuthenticationTrustResolver.class, (Object)this.trustResolver);
        if (this.userVerificationStrategy == null) {
            this.userVerificationStrategy = WebAuthnConfigurerUtil.getUserVerificationStrategyOrCreateNew(http);
        }
        http.setSharedObject(UserVerificationStrategy.class, (Object)this.userVerificationStrategy);
        ((WebAuthnProcessingFilter)this.getAuthenticationFilter()).setServerPropertyProvider(this.serverPropertyProvider);
        ((WebAuthnProcessingFilter)this.getAuthenticationFilter()).setUserVerificationStrategy(this.userVerificationStrategy);
        this.configureParameters();
        this.attestationOptionsEndpointConfig.configure(http);
        this.assertionOptionsEndpointConfig.configure(http);
    }

    private void configureParameters() {
        if (this.usernameParameter != null) {
            ((WebAuthnProcessingFilter)this.getAuthenticationFilter()).setUsernameParameter(this.usernameParameter);
        }
        if (this.passwordParameter != null) {
            ((WebAuthnProcessingFilter)this.getAuthenticationFilter()).setPasswordParameter(this.passwordParameter);
        }
        if (this.credentialIdParameter != null) {
            ((WebAuthnProcessingFilter)this.getAuthenticationFilter()).setCredentialIdParameter(this.credentialIdParameter);
        }
        if (this.clientDataJSONParameter != null) {
            ((WebAuthnProcessingFilter)this.getAuthenticationFilter()).setClientDataJSONParameter(this.clientDataJSONParameter);
        }
        if (this.authenticatorDataParameter != null) {
            ((WebAuthnProcessingFilter)this.getAuthenticationFilter()).setAuthenticatorDataParameter(this.authenticatorDataParameter);
        }
        if (this.signatureParameter != null) {
            ((WebAuthnProcessingFilter)this.getAuthenticationFilter()).setSignatureParameter(this.signatureParameter);
        }
        if (this.clientExtensionsJSONParameter != null) {
            ((WebAuthnProcessingFilter)this.getAuthenticationFilter()).setClientExtensionsJSONParameter(this.clientExtensionsJSONParameter);
        }
    }

    public WebAuthnLoginConfigurer<H> objectConverter(ObjectConverter objectConverter) {
        Assert.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.objectConverter = objectConverter;
        return this;
    }

    public WebAuthnLoginConfigurer<H> serverPropertyProvider(ServerPropertyProvider serverPropertyProvider) {
        Assert.notNull((Object)serverPropertyProvider, (String)"serverPropertyProvider must not be null");
        this.serverPropertyProvider = serverPropertyProvider;
        return this;
    }

    public WebAuthnLoginConfigurer<H> trustResolver(AuthenticationTrustResolver trustResolver) {
        Assert.notNull((Object)trustResolver, (String)"trustResolver must not be null");
        this.trustResolver = trustResolver;
        return this;
    }

    public WebAuthnLoginConfigurer<H> userVerificationStrategy(UserVerificationStrategy userVerificationStrategy) {
        Assert.notNull((Object)userVerificationStrategy, (String)"userVerificationStrategy must not be null");
        this.userVerificationStrategy = userVerificationStrategy;
        return this;
    }

    public WebAuthnLoginConfigurer<H> rpId(String rpId) {
        this.rpId = rpId;
        return this;
    }

    public WebAuthnLoginConfigurer<H> rpIdProvider(RpIdProvider rpIdProvider) {
        Assert.notNull((Object)rpIdProvider, (String)"rpIdProvider must not be null");
        this.rpIdProvider = rpIdProvider;
        return this;
    }

    public AttestationOptionsEndpointConfig attestationOptionsEndpoint() {
        return this.attestationOptionsEndpointConfig;
    }

    public AssertionOptionsEndpointConfig assertionOptionsEndpoint() {
        return this.assertionOptionsEndpointConfig;
    }

    public WebAuthnLoginConfigurer<H> usernameParameter(String usernameParameter) {
        Assert.hasText((String)usernameParameter, (String)"usernameParameter must not be null or empty");
        this.usernameParameter = usernameParameter;
        return this;
    }

    public WebAuthnLoginConfigurer<H> passwordParameter(String passwordParameter) {
        Assert.hasText((String)passwordParameter, (String)"passwordParameter must not be null or empty");
        this.passwordParameter = passwordParameter;
        return this;
    }

    public WebAuthnLoginConfigurer<H> credentialIdParameter(String credentialIdParameter) {
        Assert.hasText((String)credentialIdParameter, (String)"credentialIdParameter must not be null or empty");
        this.credentialIdParameter = credentialIdParameter;
        return this;
    }

    public WebAuthnLoginConfigurer<H> clientDataJSONParameter(String clientDataJSONParameter) {
        Assert.hasText((String)clientDataJSONParameter, (String)"clientDataJSONParameter must not be null or empty");
        this.clientDataJSONParameter = clientDataJSONParameter;
        return this;
    }

    public WebAuthnLoginConfigurer<H> authenticatorDataParameter(String authenticatorDataParameter) {
        Assert.hasText((String)authenticatorDataParameter, (String)"authenticatorDataParameter must not be null or empty");
        this.authenticatorDataParameter = authenticatorDataParameter;
        return this;
    }

    public WebAuthnLoginConfigurer<H> signatureParameter(String signatureParameter) {
        Assert.hasText((String)signatureParameter, (String)"signatureParameter must not be null or empty");
        this.signatureParameter = signatureParameter;
        return this;
    }

    public WebAuthnLoginConfigurer<H> clientExtensionsJSONParameter(String clientExtensionsJSONParameter) {
        Assert.hasText((String)clientExtensionsJSONParameter, (String)"clientExtensionsJSONParameter must not be null or empty");
        this.clientExtensionsJSONParameter = clientExtensionsJSONParameter;
        return this;
    }

    public WebAuthnLoginConfigurer<H> successForwardUrl(String forwardUrl) {
        this.successHandler((AuthenticationSuccessHandler)new ForwardAuthenticationSuccessHandler(forwardUrl));
        return this;
    }

    public WebAuthnLoginConfigurer<H> failureForwardUrl(String forwardUrl) {
        this.failureHandler((AuthenticationFailureHandler)new ForwardAuthenticationFailureHandler(forwardUrl));
        return this;
    }

    public WebAuthnLoginConfigurer<H> loginPage(String loginPage) {
        return (WebAuthnLoginConfigurer)super.loginPage(loginPage);
    }

    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return PathPatternRequestMatcher.pathPattern((HttpMethod)HttpMethod.POST, (String)loginProcessingUrl);
    }

    public class AttestationOptionsEndpointConfig {
        private String processingUrl = "/webauthn/attestation/options";
        private AttestationOptionsProvider attestationOptionsProvider = null;
        private PublicKeyCredentialUserEntityProvider userProvider;
        private final com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.RpConfig rpConfig = new RpConfig();
        private PublicKeyCredentialParameters[] pubKeyCredParams = null;
        private final com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.AuthenticatorSelectionConfig authenticatorSelectionConfig = new AuthenticatorSelectionConfig();
        private AttestationConveyancePreference attestation = null;
        private Long timeout;
        private final com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.RegistrationExtensionsClientInputsConfig extensions = new RegistrationExtensionsClientInputsConfig();

        private AttestationOptionsEndpointConfig() {
        }

        private void configure(H http) {
            AttestationOptionsEndpointFilter optionsEndpointFilter = WebAuthnConfigurerUtil.getAttestationOptionsEndpointFilterOrCreateNew(http);
            optionsEndpointFilter.setFilterProcessesUrl(this.processingUrl);
            if (this.attestationOptionsProvider == null) {
                this.attestationOptionsProvider = WebAuthnConfigurerUtil.getAttestationOptionsProviderOrCreateNew(http);
            }
            http.setSharedObject(AttestationOptionsProvider.class, (Object)this.attestationOptionsProvider);
            optionsEndpointFilter.setTrustResolver(WebAuthnLoginConfigurer.this.trustResolver);
            if (this.attestationOptionsProvider instanceof AttestationOptionsProviderImpl) {
                AttestationOptionsProviderImpl attestationOptionsProviderImpl = (AttestationOptionsProviderImpl)this.attestationOptionsProvider;
                if (this.userProvider != null) {
                    attestationOptionsProviderImpl.setPublicKeyCredentialUserEntityProvider(this.userProvider);
                }
                this.rpConfig.configure(http);
                attestationOptionsProviderImpl.setPubKeyCredParams(this.pubKeyCredParams == null ? null : Arrays.asList(this.pubKeyCredParams));
                if (this.timeout != null) {
                    attestationOptionsProviderImpl.setRegistrationTimeout(this.timeout);
                }
                attestationOptionsProviderImpl.setRegistrationAuthenticatorSelection(this.authenticatorSelectionConfig.getAuthenticatorSelectionCriteria());
                if (this.attestation != null) {
                    attestationOptionsProviderImpl.setAttestation(this.attestation);
                }
                attestationOptionsProviderImpl.setRegistrationExtensionsProvider(this.extensions.getExtensionsProvider());
            }
            http.addFilterAfter((Filter)optionsEndpointFilter, SessionManagementFilter.class);
        }

        public AttestationOptionsEndpointConfig attestationOptionsProvider(AttestationOptionsProvider attestationOptionsProvider) {
            Assert.notNull((Object)attestationOptionsProvider, (String)"attestationOptionsProvider must not be null");
            this.attestationOptionsProvider = attestationOptionsProvider;
            return this;
        }

        public AttestationOptionsEndpointConfig processingUrl(String processingUrl) {
            this.processingUrl = processingUrl;
            return this;
        }

        public AttestationOptionsEndpointConfig rp(String name) {
            this.rpConfig.name = name;
            return this;
        }

        public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.RpConfig rp() {
            return this.rpConfig;
        }

        public AttestationOptionsEndpointConfig userProvider(PublicKeyCredentialUserEntityProvider userProvider) {
            this.userProvider = userProvider;
            return this;
        }

        public AttestationOptionsEndpointConfig pubKeyCredParams(PublicKeyCredentialParameters ... pubKeyCredParams) {
            this.pubKeyCredParams = pubKeyCredParams;
            return this;
        }

        public AttestationOptionsEndpointConfig timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.AuthenticatorSelectionConfig authenticatorSelection() {
            return this.authenticatorSelectionConfig;
        }

        public AttestationOptionsEndpointConfig attestation(AttestationConveyancePreference attestation) {
            this.attestation = attestation;
            return this;
        }

        public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.RegistrationExtensionsClientInputsConfig extensions() {
            return this.extensions;
        }

        public WebAuthnLoginConfigurer<H> and() {
            return WebAuthnLoginConfigurer.this;
        }

        public class RpConfig {
            private String id = null;
            private String name = null;
            private RpIdProvider idProvider = null;

            private RpConfig() {
            }

            private void configure(H http) {
                if (AttestationOptionsEndpointConfig.this.attestationOptionsProvider instanceof AttestationOptionsProviderImpl) {
                    AttestationOptionsProviderImpl attestationOptionsProviderImpl = (AttestationOptionsProviderImpl)AttestationOptionsEndpointConfig.this.attestationOptionsProvider;
                    if (AttestationOptionsEndpointConfig.this.rpConfig.id != null) {
                        attestationOptionsProviderImpl.setRpId(AttestationOptionsEndpointConfig.this.rpConfig.id);
                    } else if (WebAuthnLoginConfigurer.this.rpId != null) {
                        attestationOptionsProviderImpl.setRpId(WebAuthnLoginConfigurer.this.rpId);
                    }
                    if (AttestationOptionsEndpointConfig.this.rpConfig.name != null) {
                        attestationOptionsProviderImpl.setRpName(AttestationOptionsEndpointConfig.this.rpConfig.name);
                    }
                    if (AttestationOptionsEndpointConfig.this.rpConfig.idProvider != null) {
                        attestationOptionsProviderImpl.setRpIdProvider(AttestationOptionsEndpointConfig.this.rpConfig.idProvider);
                    } else if (WebAuthnLoginConfigurer.this.rpIdProvider != null) {
                        attestationOptionsProviderImpl.setRpIdProvider(WebAuthnLoginConfigurer.this.rpIdProvider);
                    }
                }
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.RpConfig id(String id) {
                Assert.hasText((String)id, (String)"id parameter must not be null or empty");
                this.id = id;
                return this;
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.RpConfig name(String name) {
                Assert.hasText((String)name, (String)"name parameter must not be null or empty");
                this.name = name;
                return this;
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.RpConfig idProvider(RpIdProvider idProvider) {
                Assert.notNull((Object)idProvider, (String)"idProvider parameter must not be null");
                this.idProvider = idProvider;
                return this;
            }

            public AttestationOptionsEndpointConfig and() {
                return AttestationOptionsEndpointConfig.this;
            }
        }

        public class AuthenticatorSelectionConfig {
            private AuthenticatorAttachment authenticatorAttachment;
            private ResidentKeyRequirement residentKey;
            private UserVerificationRequirement userVerification;

            private AuthenticatorSelectionConfig() {
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.AuthenticatorSelectionConfig authenticatorAttachment(AuthenticatorAttachment authenticatorAttachment) {
                Assert.notNull((Object)authenticatorAttachment, (String)"authenticatorAttachment parameter must not be null or empty");
                this.authenticatorAttachment = authenticatorAttachment;
                return this;
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.AuthenticatorSelectionConfig residentKey(ResidentKeyRequirement residentKey) {
                Assert.notNull((Object)residentKey, (String)"residentKey parameter must not be null or empty");
                this.residentKey = residentKey;
                return this;
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.AuthenticatorSelectionConfig userVerification(UserVerificationRequirement userVerification) {
                Assert.notNull((Object)userVerification, (String)"userVerification parameter must not be null or empty");
                this.userVerification = userVerification;
                return this;
            }

            public AttestationOptionsEndpointConfig and() {
                return AttestationOptionsEndpointConfig.this;
            }

            private AuthenticatorSelectionCriteria getAuthenticatorSelectionCriteria() {
                return new AuthenticatorSelectionCriteria(this.authenticatorAttachment, Boolean.valueOf(this.residentKey == ResidentKeyRequirement.REQUIRED), this.residentKey, this.userVerification);
            }
        }

        public class RegistrationExtensionsClientInputsConfig {
            private final AuthenticationExtensionsClientInputs.BuilderForRegistration builder = new AuthenticationExtensionsClientInputs.BuilderForRegistration();
            private List<RegistrationExtensionProvider> providers = Collections.emptyList();

            private RegistrationExtensionsClientInputsConfig() {
            }

            private AuthenticationExtensionsClientInputsProvider<RegistrationExtensionClientInput> getExtensionsProvider() {
                return httpServletRequest -> {
                    this.providers.forEach(provider -> provider.provide(this.builder, httpServletRequest));
                    return this.builder.build();
                };
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.RegistrationExtensionsClientInputsConfig uvm(Boolean uvm) {
                Assert.notNull((Object)uvm, (String)"uvm must not be null");
                this.builder.setUvm(uvm);
                return this;
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.RegistrationExtensionsClientInputsConfig credProps(Boolean credProps) {
                Assert.notNull((Object)credProps, (String)"credProps must not be null");
                this.builder.setCredProps(credProps);
                return this;
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.RegistrationExtensionsClientInputsConfig entry(String key, Serializable value) {
                Assert.notNull((Object)key, (String)"key must not be null");
                Assert.notNull((Object)value, (String)"value must not be null");
                this.builder.set(key, (Object)value);
                return this;
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AttestationOptionsEndpointConfig.RegistrationExtensionsClientInputsConfig extensionProviders(RegistrationExtensionProvider ... providers) {
                this.providers = Arrays.asList(providers);
                return this;
            }

            public WebAuthnLoginConfigurer<H> and() {
                return WebAuthnLoginConfigurer.this;
            }
        }
    }

    public class AssertionOptionsEndpointConfig {
        private String processingUrl = "/webauthn/assertion/options";
        private AssertionOptionsProvider assertionOptionsProvider;
        private String rpId = null;
        private Long timeout;
        private final com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AssertionOptionsEndpointConfig.AuthenticationExtensionsClientInputsConfig extensions = new AuthenticationExtensionsClientInputsConfig();
        private UserVerificationRequirement userVerification;
        private RpIdProvider rpIdProvider = null;

        private AssertionOptionsEndpointConfig() {
        }

        private void configure(H http) {
            AssertionOptionsEndpointFilter optionsEndpointFilter = WebAuthnConfigurerUtil.getAssertionOptionsEndpointFilterOrCreateNew(http);
            optionsEndpointFilter.setFilterProcessesUrl(this.processingUrl);
            if (this.assertionOptionsProvider == null) {
                this.assertionOptionsProvider = WebAuthnConfigurerUtil.getAssertionOptionsProviderOrCreateNew(http);
            }
            http.setSharedObject(AssertionOptionsProvider.class, (Object)this.assertionOptionsProvider);
            optionsEndpointFilter.setTrustResolver(WebAuthnLoginConfigurer.this.trustResolver);
            if (this.assertionOptionsProvider instanceof AssertionOptionsProviderImpl) {
                AssertionOptionsProviderImpl optionsProviderImpl = (AssertionOptionsProviderImpl)this.assertionOptionsProvider;
                if (this.rpId != null) {
                    optionsProviderImpl.setRpId(this.rpId);
                } else if (WebAuthnLoginConfigurer.this.rpId != null) {
                    optionsProviderImpl.setRpId(WebAuthnLoginConfigurer.this.rpId);
                }
                if (this.rpIdProvider != null) {
                    optionsProviderImpl.setRpIdProvider(this.rpIdProvider);
                } else if (WebAuthnLoginConfigurer.this.rpIdProvider != null) {
                    optionsProviderImpl.setRpIdProvider(WebAuthnLoginConfigurer.this.rpIdProvider);
                }
                if (this.timeout != null) {
                    optionsProviderImpl.setAuthenticationTimeout(this.timeout);
                }
                optionsProviderImpl.setAuthenticationUserVerification(this.userVerification);
                optionsProviderImpl.setAuthenticationExtensionsProvider(this.extensions.getExtensionsProvider());
            }
            http.addFilterAfter((Filter)optionsEndpointFilter, SessionManagementFilter.class);
        }

        public AssertionOptionsEndpointConfig assertionOptionsProvider(AssertionOptionsProvider assertionOptionsProvider) {
            Assert.notNull((Object)assertionOptionsProvider, (String)"assertionOptionsProvider must not be null");
            this.assertionOptionsProvider = assertionOptionsProvider;
            return this;
        }

        public AssertionOptionsEndpointConfig processingUrl(String processingUrl) {
            this.processingUrl = processingUrl;
            return this;
        }

        public AssertionOptionsEndpointConfig rpId(String rpId) {
            this.rpId = rpId;
            return this;
        }

        public AssertionOptionsEndpointConfig timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public AssertionOptionsEndpointConfig userVerification(UserVerificationRequirement userVerification) {
            this.userVerification = userVerification;
            return this;
        }

        public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AssertionOptionsEndpointConfig.AuthenticationExtensionsClientInputsConfig extensions() {
            return this.extensions;
        }

        public AssertionOptionsEndpointConfig rpIdProvider(RpIdProvider rpIdProvider) {
            this.rpIdProvider = rpIdProvider;
            return this;
        }

        public WebAuthnLoginConfigurer<H> and() {
            return WebAuthnLoginConfigurer.this;
        }

        public class AuthenticationExtensionsClientInputsConfig {
            private final AuthenticationExtensionsClientInputs.BuilderForAuthentication builder = new AuthenticationExtensionsClientInputs.BuilderForAuthentication();
            private List<AuthenticationExtensionProvider> providers = Collections.emptyList();

            private AuthenticationExtensionsClientInputsConfig() {
            }

            private AuthenticationExtensionsClientInputsProvider<AuthenticationExtensionClientInput> getExtensionsProvider() {
                return httpServletRequest -> {
                    this.providers.forEach(provider -> provider.provide(this.builder, httpServletRequest));
                    return this.builder.build();
                };
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AssertionOptionsEndpointConfig.AuthenticationExtensionsClientInputsConfig appid(String appid) {
                Assert.notNull((Object)appid, (String)"appid must not be null");
                this.builder.setAppid(appid);
                return this;
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AssertionOptionsEndpointConfig.AuthenticationExtensionsClientInputsConfig appidExclude(String appidExclude) {
                Assert.notNull((Object)appidExclude, (String)"appidExclude must not be null");
                this.builder.setAppidExclude(appidExclude);
                return this;
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AssertionOptionsEndpointConfig.AuthenticationExtensionsClientInputsConfig uvm(Boolean uvm) {
                Assert.notNull((Object)uvm, (String)"uvm must not be null");
                this.builder.setUvm(uvm);
                return this;
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AssertionOptionsEndpointConfig.AuthenticationExtensionsClientInputsConfig entry(String key, Serializable value) {
                Assert.notNull((Object)key, (String)"key must not be null");
                Assert.notNull((Object)value, (String)"value must not be null");
                this.builder.set(key, (Object)value);
                return this;
            }

            public com.webauthn4j.springframework.security.config.configurers.WebAuthnLoginConfigurer$AssertionOptionsEndpointConfig.AuthenticationExtensionsClientInputsConfig extensionProviders(AuthenticationExtensionProvider ... providers) {
                this.providers = Arrays.asList(providers);
                return this;
            }

            public AssertionOptionsEndpointConfig and() {
                return AssertionOptionsEndpointConfig.this;
            }
        }
    }
}

