/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.credential;

import com.webauthn4j.springframework.security.credential.WebAuthnCredentialRecord;
import com.webauthn4j.springframework.security.credential.WebAuthnCredentialRecordManager;
import com.webauthn4j.springframework.security.exception.CredentialIdNotFoundException;
import com.webauthn4j.springframework.security.exception.PrincipalNotFoundException;
import com.webauthn4j.util.Base64UrlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InMemoryWebAuthnCredentialRecordManager
implements WebAuthnCredentialRecordManager {
    private Map<Object, Map<String, WebAuthnCredentialRecord>> map = new HashMap<Object, Map<String, WebAuthnCredentialRecord>>();

    @Override
    public void updateCounter(byte[] credentialId, long counter) throws CredentialIdNotFoundException {
        WebAuthnCredentialRecord webAuthnCredentialRecord = this.loadCredentialRecordByCredentialId(credentialId);
        webAuthnCredentialRecord.setCounter(counter);
    }

    @Override
    public WebAuthnCredentialRecord loadCredentialRecordByCredentialId(byte[] credentialId) throws CredentialIdNotFoundException {
        return this.map.values().stream().map(innerMap -> (WebAuthnCredentialRecord)innerMap.get(Base64UrlUtil.encodeToString((byte[])credentialId))).filter(Objects::nonNull).findFirst().orElseThrow(() -> new CredentialIdNotFoundException("credentialId not found."));
    }

    @Override
    public List<WebAuthnCredentialRecord> loadCredentialRecordsByUserPrincipal(Object userPrincipal) {
        Map<String, WebAuthnCredentialRecord> innerMap = this.map.get(userPrincipal);
        if (innerMap == null || innerMap.isEmpty()) {
            throw new PrincipalNotFoundException("principal not found.");
        }
        return Collections.unmodifiableList(new ArrayList<WebAuthnCredentialRecord>(innerMap.values()));
    }

    @Override
    public void createCredentialRecord(WebAuthnCredentialRecord webAuthnCredentialRecord) {
        Object userPrincipal = webAuthnCredentialRecord.getUserPrincipal();
        if (!this.map.containsKey(userPrincipal)) {
            this.map.put(userPrincipal, new HashMap());
        }
        this.map.get(userPrincipal).put(Base64UrlUtil.encodeToString((byte[])webAuthnCredentialRecord.getAttestedCredentialData().getCredentialId()), webAuthnCredentialRecord);
    }

    @Override
    public void deleteCredentialRecord(byte[] credentialId) {
        for (Map.Entry<Object, Map<String, WebAuthnCredentialRecord>> entry : this.map.entrySet()) {
            WebAuthnCredentialRecord webAuthnCredentialRecord = entry.getValue().get(Base64UrlUtil.encodeToString((byte[])credentialId));
            if (webAuthnCredentialRecord == null) continue;
            entry.getValue().remove(Base64UrlUtil.encodeToString((byte[])credentialId));
            return;
        }
        throw new CredentialIdNotFoundException("credentialId not found.");
    }

    @Override
    public boolean credentialRecordExists(byte[] credentialId) {
        return this.map.values().stream().anyMatch(innerMap -> innerMap.get(Base64UrlUtil.encodeToString((byte[])credentialId)) != null);
    }
}

