/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security;

import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.credential.CredentialRecord;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.springframework.security.SpringSecurityWebAuthnMessageSource;
import com.webauthn4j.springframework.security.WebAuthnAssertionAuthenticationToken;
import com.webauthn4j.springframework.security.WebAuthnAuthenticationParameters;
import com.webauthn4j.springframework.security.WebAuthnAuthenticationRequest;
import com.webauthn4j.springframework.security.WebAuthnAuthenticationToken;
import com.webauthn4j.springframework.security.credential.WebAuthnCredentialRecord;
import com.webauthn4j.springframework.security.credential.WebAuthnCredentialRecordService;
import com.webauthn4j.springframework.security.exception.CredentialIdNotFoundException;
import com.webauthn4j.springframework.security.util.internal.ExceptionUtil;
import com.webauthn4j.util.exception.WebAuthnException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class WebAuthnAuthenticationProvider
implements AuthenticationProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final MessageSourceAccessor messages = SpringSecurityWebAuthnMessageSource.getAccessor();
    private final WebAuthnCredentialRecordService webAuthnCredentialRecordService;
    private final WebAuthnManager webAuthnManager;
    private boolean hideCredentialIdNotFoundExceptions = true;

    public WebAuthnAuthenticationProvider(WebAuthnCredentialRecordService webAuthnCredentialRecordService, WebAuthnManager webAuthnManager) {
        Assert.notNull((Object)webAuthnCredentialRecordService, (String)"webAuthnCredentialRecordService must not be null");
        Assert.notNull((Object)webAuthnManager, (String)"webAuthnManager must not be null");
        this.webAuthnCredentialRecordService = webAuthnCredentialRecordService;
        this.webAuthnManager = webAuthnManager;
    }

    public Authentication authenticate(Authentication authentication) {
        if (!this.supports(authentication.getClass())) {
            throw new IllegalArgumentException("Only WebAuthnAssertionAuthenticationToken is supported, " + String.valueOf(authentication.getClass()) + " was attempted");
        }
        WebAuthnAssertionAuthenticationToken authenticationToken = (WebAuthnAssertionAuthenticationToken)authentication;
        WebAuthnAuthenticationRequest credentials = authenticationToken.getCredentials();
        if (credentials == null) {
            this.logger.debug((Object)"Authentication failed: no credentials provided");
            throw new BadCredentialsException(this.messages.getMessage("WebAuthnAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        byte[] credentialId = credentials.getCredentialId();
        WebAuthnCredentialRecord webAuthnCredentialRecord = this.retrieveCredentialRecord(credentialId);
        this.doAuthenticate(authenticationToken, webAuthnCredentialRecord);
        this.webAuthnCredentialRecordService.updateCounter(credentialId, webAuthnCredentialRecord.getCounter());
        return this.createSuccessAuthentication(authenticationToken, webAuthnCredentialRecord);
    }

    protected Authentication createSuccessAuthentication(WebAuthnAssertionAuthenticationToken authenticationToken, WebAuthnCredentialRecord webAuthnCredentialRecord) {
        Object principal = webAuthnCredentialRecord.getUserPrincipal();
        Collection authorities = null;
        if (principal instanceof UserDetails) {
            authorities = ((UserDetails)principal).getAuthorities();
        }
        WebAuthnAuthenticationToken webAuthnAuthenticationToken = new WebAuthnAuthenticationToken(principal, authenticationToken.getCredentials(), authorities);
        webAuthnAuthenticationToken.setDetails(authenticationToken.getDetails());
        return webAuthnAuthenticationToken;
    }

    public boolean supports(Class<?> authentication) {
        return WebAuthnAssertionAuthenticationToken.class.isAssignableFrom(authentication);
    }

    void doAuthenticate(WebAuthnAssertionAuthenticationToken authenticationToken, WebAuthnCredentialRecord webAuthnCredentialRecord) {
        WebAuthnAuthenticationRequest request = authenticationToken.getCredentials();
        WebAuthnAuthenticationParameters parameters = authenticationToken.getParameters();
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(request.getCredentialId(), request.getAuthenticatorData(), request.getClientDataJSON(), request.getClientExtensionsJSON(), request.getSignature());
        AuthenticationParameters authenticationParameters = new AuthenticationParameters(parameters.getServerProperty(), (CredentialRecord)webAuthnCredentialRecord, null, parameters.isUserVerificationRequired(), parameters.isUserPresenceRequired());
        try {
            this.webAuthnManager.verify(authenticationRequest, authenticationParameters);
        }
        catch (WebAuthnException e) {
            throw ExceptionUtil.wrapWithAuthenticationException(e);
        }
    }

    public boolean isHideCredentialIdNotFoundExceptions() {
        return this.hideCredentialIdNotFoundExceptions;
    }

    public void setHideCredentialIdNotFoundExceptions(boolean hideCredentialIdNotFoundExceptions) {
        this.hideCredentialIdNotFoundExceptions = hideCredentialIdNotFoundExceptions;
    }

    WebAuthnCredentialRecord retrieveCredentialRecord(byte[] credentialId) {
        WebAuthnCredentialRecord webAuthnCredentialRecord;
        try {
            webAuthnCredentialRecord = this.webAuthnCredentialRecordService.loadCredentialRecordByCredentialId(credentialId);
        }
        catch (CredentialIdNotFoundException notFound) {
            if (this.hideCredentialIdNotFoundExceptions) {
                throw new BadCredentialsException(this.messages.getMessage("WebAuthnAuthenticationProvider.badCredentials", "Bad credentials"));
            }
            throw notFound;
        }
        catch (Exception repositoryProblem) {
            throw new InternalAuthenticationServiceException(repositoryProblem.getMessage(), (Throwable)repositoryProblem);
        }
        if (webAuthnCredentialRecord == null) {
            throw new InternalAuthenticationServiceException("webAuthnCredentialRecordService returned null, which is an interface contract violation");
        }
        return webAuthnCredentialRecord;
    }
}

