/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.data.statement.AlternativeDescriptions;
import com.webauthn4j.metadata.data.statement.AttachmentHints;
import com.webauthn4j.metadata.data.statement.AttestationType;
import com.webauthn4j.metadata.data.statement.AuthenticationAlgorithm;
import com.webauthn4j.metadata.data.statement.DisplayPNGCharacteristicsDescriptor;
import com.webauthn4j.metadata.data.statement.EcdaaTrustAnchor;
import com.webauthn4j.metadata.data.statement.ExtensionDescriptor;
import com.webauthn4j.metadata.data.statement.KeyProtections;
import com.webauthn4j.metadata.data.statement.MatcherProtections;
import com.webauthn4j.metadata.data.statement.PublicKeyRepresentationFormat;
import com.webauthn4j.metadata.data.statement.TransactionConfirmationDisplays;
import com.webauthn4j.metadata.data.statement.VerificationMethodANDCombinations;
import com.webauthn4j.metadata.data.statement.Version;
import com.webauthn4j.metadata.data.uaf.AAID;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.List;

public class MetadataStatement
implements Serializable {
    private String legalHeader;
    private AAID aaid;
    private AAGUID aaguid;
    private List<String> attestationCertificateKeyIdentifiers;
    private String description;
    private AlternativeDescriptions alternativeDescriptions;
    private Integer authenticatorVersion;
    private String protocolFamily;
    private List<Version> upv;
    private String assertionScheme;
    private AuthenticationAlgorithm authenticationAlgorithm;
    private List<AuthenticationAlgorithm> authenticationAlgorithms;
    private PublicKeyRepresentationFormat publicKeyAlgAndEncoding;
    private List<PublicKeyRepresentationFormat> publicKeyAlgAndEncodings;
    private List<AttestationType> attestationTypes;
    private List<VerificationMethodANDCombinations> userVerificationDetails;
    private KeyProtections keyProtection;
    private Boolean isKeyRestricted;
    private Boolean isFreshUserVerificationRequired;
    private MatcherProtections matcherProtection;
    private Integer cryptoStrength;
    private String operationEnv;
    private AttachmentHints attachmentHint;
    private Boolean isSecondFactorOnly;
    private TransactionConfirmationDisplays tcDisplay;
    private String tcDisplayContentType;
    private List<DisplayPNGCharacteristicsDescriptor> tcDisplayPNGCharacteristics;
    private List<X509Certificate> attestationRootCertificates;
    private List<EcdaaTrustAnchor> ecdaaTrustAnchors;
    private String icon;
    private List<ExtensionDescriptor> supportedExtensions;

    @JsonCreator
    public MetadataStatement(@JsonProperty(value="legalHeader") String legalHeader, @JsonProperty(value="aaid") AAID aaid, @JsonProperty(value="aaguid") AAGUID aaguid, @JsonProperty(value="attestationCertificateKeyIdentifiers") List<String> attestationCertificateKeyIdentifiers, @JsonProperty(value="description") String description, @JsonProperty(value="alternativeDescriptions") AlternativeDescriptions alternativeDescriptions, @JsonProperty(value="authenticatorVersion") Integer authenticatorVersion, @JsonProperty(value="protocolFamily") String protocolFamily, @JsonProperty(value="upv") List<Version> upv, @JsonProperty(value="assertionScheme") String assertionScheme, @JsonProperty(value="authenticationAlgorithm") AuthenticationAlgorithm authenticationAlgorithm, @JsonProperty(value="authenticationAlgorithms") List<AuthenticationAlgorithm> authenticationAlgorithms, @JsonProperty(value="publicKeyAlgAndEncoding") PublicKeyRepresentationFormat publicKeyAlgAndEncoding, @JsonProperty(value="publicKeyAlgAndEncodings") List<PublicKeyRepresentationFormat> publicKeyAlgAndEncodings, @JsonProperty(value="attestationTypes") List<AttestationType> attestationTypes, @JsonProperty(value="userVerificationDetails") List<VerificationMethodANDCombinations> userVerificationDetails, @JsonProperty(value="keyProtection") KeyProtections keyProtection, @JsonProperty(value="isKeyRestricted") Boolean isKeyRestricted, @JsonProperty(value="isFreshUserVerificationRequired") Boolean isFreshUserVerificationRequired, @JsonProperty(value="matcherProtection") MatcherProtections matcherProtection, @JsonProperty(value="cryptoStrength") Integer cryptoStrength, @JsonProperty(value="operationEnv") String operationEnv, @JsonProperty(value="attachmentHint") AttachmentHints attachmentHint, @JsonProperty(value="isSecondFactorOnly") Boolean isSecondFactorOnly, @JsonProperty(value="tcDisplay") TransactionConfirmationDisplays tcDisplay, @JsonProperty(value="tcDisplayContentType") String tcDisplayContentType, @JsonProperty(value="tcDisplayPNGCharacteristics") List<DisplayPNGCharacteristicsDescriptor> tcDisplayPNGCharacteristics, @JsonProperty(value="attestationRootCertificates") List<X509Certificate> attestationRootCertificates, @JsonProperty(value="ecdaaTrustAnchors") List<EcdaaTrustAnchor> ecdaaTrustAnchors, @JsonProperty(value="icon") String icon, @JsonProperty(value="supportedExtensions") List<ExtensionDescriptor> supportedExtensions) {
        this.legalHeader = legalHeader;
        this.aaid = aaid;
        this.aaguid = aaguid;
        this.attestationCertificateKeyIdentifiers = CollectionUtil.unmodifiableList(attestationCertificateKeyIdentifiers);
        this.alternativeDescriptions = alternativeDescriptions;
        this.description = description;
        this.authenticatorVersion = authenticatorVersion;
        this.protocolFamily = protocolFamily;
        this.upv = CollectionUtil.unmodifiableList(upv);
        this.assertionScheme = assertionScheme;
        this.authenticationAlgorithm = authenticationAlgorithm;
        this.authenticationAlgorithms = CollectionUtil.unmodifiableList(authenticationAlgorithms);
        this.publicKeyAlgAndEncoding = publicKeyAlgAndEncoding;
        this.publicKeyAlgAndEncodings = CollectionUtil.unmodifiableList(publicKeyAlgAndEncodings);
        this.attestationTypes = attestationTypes;
        this.userVerificationDetails = CollectionUtil.unmodifiableList(userVerificationDetails);
        this.keyProtection = keyProtection;
        this.isKeyRestricted = isKeyRestricted;
        this.isFreshUserVerificationRequired = isFreshUserVerificationRequired;
        this.matcherProtection = matcherProtection;
        this.cryptoStrength = cryptoStrength;
        this.operationEnv = operationEnv;
        this.attachmentHint = attachmentHint;
        this.isSecondFactorOnly = isSecondFactorOnly;
        this.tcDisplay = tcDisplay;
        this.tcDisplayContentType = tcDisplayContentType;
        this.tcDisplayPNGCharacteristics = CollectionUtil.unmodifiableList(tcDisplayPNGCharacteristics);
        this.attestationRootCertificates = CollectionUtil.unmodifiableList(attestationRootCertificates);
        this.ecdaaTrustAnchors = CollectionUtil.unmodifiableList(ecdaaTrustAnchors);
        this.icon = icon;
        this.supportedExtensions = CollectionUtil.unmodifiableList(supportedExtensions);
    }

    public String getLegalHeader() {
        return this.legalHeader;
    }

    public AAID getAaid() {
        return this.aaid;
    }

    public AAGUID getAaguid() {
        return this.aaguid;
    }

    public List<String> getAttestationCertificateKeyIdentifiers() {
        return this.attestationCertificateKeyIdentifiers;
    }

    public String getDescription() {
        return this.description;
    }

    public AlternativeDescriptions getAlternativeDescriptions() {
        return this.alternativeDescriptions;
    }

    public Integer getAuthenticatorVersion() {
        return this.authenticatorVersion;
    }

    public String getProtocolFamily() {
        return this.protocolFamily;
    }

    public List<Version> getUpv() {
        return this.upv;
    }

    public String getAssertionScheme() {
        return this.assertionScheme;
    }

    public AuthenticationAlgorithm getAuthenticationAlgorithm() {
        return this.authenticationAlgorithm;
    }

    public List<AuthenticationAlgorithm> getAuthenticationAlgorithms() {
        return this.authenticationAlgorithms;
    }

    public PublicKeyRepresentationFormat getPublicKeyAlgAndEncoding() {
        return this.publicKeyAlgAndEncoding;
    }

    public List<PublicKeyRepresentationFormat> getPublicKeyAlgAndEncodings() {
        return this.publicKeyAlgAndEncodings;
    }

    public List<AttestationType> getAttestationTypes() {
        return this.attestationTypes;
    }

    public List<VerificationMethodANDCombinations> getUserVerificationDetails() {
        return this.userVerificationDetails;
    }

    public KeyProtections getKeyProtection() {
        return this.keyProtection;
    }

    public Boolean getKeyRestricted() {
        return this.isKeyRestricted;
    }

    public Boolean getFreshUserVerificationRequired() {
        return this.isFreshUserVerificationRequired;
    }

    public MatcherProtections getMatcherProtection() {
        return this.matcherProtection;
    }

    public Integer getCryptoStrength() {
        return this.cryptoStrength;
    }

    public String getOperationEnv() {
        return this.operationEnv;
    }

    public AttachmentHints getAttachmentHint() {
        return this.attachmentHint;
    }

    public Boolean getSecondFactorOnly() {
        return this.isSecondFactorOnly;
    }

    public TransactionConfirmationDisplays getTcDisplay() {
        return this.tcDisplay;
    }

    public String getTcDisplayContentType() {
        return this.tcDisplayContentType;
    }

    public List<DisplayPNGCharacteristicsDescriptor> getTcDisplayPNGCharacteristics() {
        return this.tcDisplayPNGCharacteristics;
    }

    public List<X509Certificate> getAttestationRootCertificates() {
        return this.attestationRootCertificates;
    }

    public List<EcdaaTrustAnchor> getEcdaaTrustAnchors() {
        return this.ecdaaTrustAnchors;
    }

    public String getIcon() {
        return this.icon;
    }

    public List<ExtensionDescriptor> getSupportedExtensions() {
        return this.supportedExtensions;
    }
}

