/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum AttestationType {
    BASIC_FULL(15879),
    BASIC_SURROGATE(15880),
    ECDAA(15881),
    ATTCA(15882);

    private final int value;

    private AttestationType(int value) {
        this.value = value;
    }

    public static AttestationType create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException("value '" + value + "' is out of range");
        }
        switch (value) {
            case 15879: {
                return BASIC_FULL;
            }
            case 15880: {
                return BASIC_SURROGATE;
            }
            case 15881: {
                return ECDAA;
            }
            case 15882: {
                return ATTCA;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static AttestationType deserialize(int value) throws InvalidFormatException {
        try {
            return AttestationType.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AttestationType.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

