/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.metadata.data.statement.AttestationType;

public enum PublicKeyRepresentationFormat {
    ECC_X962_RAW(256),
    ECC_X962_DER(257),
    RSA_2048_RAW(258),
    RSA_2048_DER(259),
    COSE(260);

    private final int value;

    private PublicKeyRepresentationFormat(int value) {
        this.value = value;
    }

    public static PublicKeyRepresentationFormat create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException("value '" + value + "' is out of range");
        }
        switch (value) {
            case 256: {
                return ECC_X962_RAW;
            }
            case 257: {
                return ECC_X962_DER;
            }
            case 258: {
                return RSA_2048_RAW;
            }
            case 259: {
                return RSA_2048_DER;
            }
            case 260: {
                return COSE;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static PublicKeyRepresentationFormat fromJson(int value) throws InvalidFormatException {
        try {
            return PublicKeyRepresentationFormat.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AttestationType.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

