/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.webauthn4j.metadata.data.statement.VerificationMethodDescriptor;
import com.webauthn4j.util.AssertUtil;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class VerificationMethodANDCombinations
extends AbstractList<VerificationMethodDescriptor> {
    private VerificationMethodDescriptor[] descriptors;
    private final int size;

    @JsonCreator
    public VerificationMethodANDCombinations(List<VerificationMethodDescriptor> descriptors) {
        AssertUtil.notNull(descriptors, (String)"descriptors must not be null");
        this.size = descriptors.size();
        this.descriptors = descriptors.toArray(new VerificationMethodDescriptor[this.size]);
    }

    public VerificationMethodANDCombinations() {
        this(Collections.emptyList());
    }

    @Override
    public VerificationMethodDescriptor get(int index) {
        return this.descriptors[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VerificationMethodANDCombinations that = (VerificationMethodANDCombinations)o;
        return this.size == that.size && Arrays.equals(this.descriptors, that.descriptors);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.size);
        result = 31 * result + Arrays.hashCode(this.descriptors);
        return result;
    }
}

