/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum TransactionConfirmationDisplay {
    ANY(1),
    PRIVILEGED_SOFTWARE(2),
    TEE(4),
    HARDWARE(8),
    REMOTE(16);

    private final int value;

    private TransactionConfirmationDisplay(int value) {
        this.value = value;
    }

    public static TransactionConfirmationDisplay create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException("value '" + value + "' is out of range");
        }
        switch (value) {
            case 1: {
                return ANY;
            }
            case 2: {
                return PRIVILEGED_SOFTWARE;
            }
            case 4: {
                return TEE;
            }
            case 8: {
                return HARDWARE;
            }
            case 16: {
                return REMOTE;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static TransactionConfirmationDisplay fromJson(int value) throws InvalidFormatException {
        try {
            return TransactionConfirmationDisplay.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, TransactionConfirmationDisplay.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

