/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.metadata.data.statement.KeyProtection;

public enum MatcherProtection {
    SOFTWARE(1),
    TEE(2),
    ON_CHIP(4);

    private final int value;

    private MatcherProtection(int value) {
        this.value = value;
    }

    public static MatcherProtection create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException("value '" + value + "' is out of range");
        }
        switch (value) {
            case 1: {
                return SOFTWARE;
            }
            case 2: {
                return TEE;
            }
            case 4: {
                return ON_CHIP;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static MatcherProtection fromJson(int value) throws InvalidFormatException {
        try {
            return MatcherProtection.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, KeyProtection.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

