/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.metadata.HttpClient;
import com.webauthn4j.metadata.exception.MDSException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class SimpleHttpClient
implements HttpClient {
    @Override
    @NotNull
    public String fetch(@NotNull String url) {
        try {
            URL fetchUrl = new URL(url);
            HttpURLConnection urlConnection = (HttpURLConnection)fetchUrl.openConnection();
            urlConnection.setRequestMethod("GET");
            urlConnection.connect();
            int status = urlConnection.getResponseCode();
            if (status == 200) {
                InputStream inputStream = urlConnection.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(inputStream);
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                int result = bis.read();
                while (result != -1) {
                    buf.write((byte)result);
                    result = bis.read();
                }
                bis.close();
                return buf.toString(StandardCharsets.UTF_8);
            }
            throw new MDSException("failed to fetch " + url);
        }
        catch (IOException e) {
            throw new MDSException("failed to fetch " + url, e);
        }
    }
}

