/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.data.statement.MetadataStatement;
import com.webauthn4j.metadata.data.toc.BiometricStatusReport;
import com.webauthn4j.metadata.data.toc.StatusReport;
import com.webauthn4j.metadata.data.uaf.AAID;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetadataBLOBPayloadEntry {
    @Nullable
    private final AAID aaid;
    @Nullable
    private final AAGUID aaguid;
    @Nullable
    private final List<String> attestationCertificateKeyIdentifiers;
    @Nullable
    private final MetadataStatement metadataStatement;
    @Nullable
    private final List<BiometricStatusReport> biometricStatusReports;
    @NotNull
    private final List<StatusReport> statusReports;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @JsonSerialize(using=LocalDateSerializer.class)
    @NotNull
    private final LocalDate timeOfLastStatusChange;
    @Nullable
    private final String rogueListURL;
    @Nullable
    private final String rogueListHash;

    public MetadataBLOBPayloadEntry(@JsonProperty(value="aaid") @Nullable AAID aaid, @JsonProperty(value="aaguid") @Nullable AAGUID aaguid, @JsonProperty(value="attestationCertificateKeyIdentifiers") @Nullable List<String> attestationCertificateKeyIdentifiers, @JsonProperty(value="metadataStatement") @Nullable MetadataStatement metadataStatement, @JsonProperty(value="biometricStatusReports") @Nullable List<BiometricStatusReport> biometricStatusReports, @JsonProperty(value="statusReports") @NotNull List<StatusReport> statusReports, @JsonProperty(value="timeOfLastStatusChange") @NotNull LocalDate timeOfLastStatusChange, @JsonProperty(value="rogueListURL") @Nullable String rogueListURL, @JsonProperty(value="rogueListHash") @Nullable String rogueListHash) {
        this.aaid = aaid;
        this.aaguid = aaguid;
        this.attestationCertificateKeyIdentifiers = attestationCertificateKeyIdentifiers;
        this.metadataStatement = metadataStatement;
        this.biometricStatusReports = biometricStatusReports;
        this.statusReports = statusReports;
        this.timeOfLastStatusChange = timeOfLastStatusChange;
        this.rogueListURL = rogueListURL;
        this.rogueListHash = rogueListHash;
    }

    @Nullable
    public AAID getAaid() {
        return this.aaid;
    }

    @Nullable
    public AAGUID getAaguid() {
        return this.aaguid;
    }

    @Nullable
    public List<String> getAttestationCertificateKeyIdentifiers() {
        return this.attestationCertificateKeyIdentifiers;
    }

    @Nullable
    public MetadataStatement getMetadataStatement() {
        return this.metadataStatement;
    }

    @Nullable
    public List<BiometricStatusReport> getBiometricStatusReports() {
        return this.biometricStatusReports;
    }

    @NotNull
    public List<StatusReport> getStatusReports() {
        return this.statusReports;
    }

    @NotNull
    public LocalDate getTimeOfLastStatusChange() {
        return this.timeOfLastStatusChange;
    }

    @Nullable
    public String getRogueListURL() {
        return this.rogueListURL;
    }

    @Nullable
    public String getRogueListHash() {
        return this.rogueListHash;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataBLOBPayloadEntry that = (MetadataBLOBPayloadEntry)o;
        return Objects.equals(this.aaid, that.aaid) && Objects.equals(this.aaguid, that.aaguid) && Objects.equals(this.attestationCertificateKeyIdentifiers, that.attestationCertificateKeyIdentifiers) && Objects.equals(this.metadataStatement, that.metadataStatement) && Objects.equals(this.biometricStatusReports, that.biometricStatusReports) && this.statusReports.equals(that.statusReports) && this.timeOfLastStatusChange.equals(that.timeOfLastStatusChange) && Objects.equals(this.rogueListURL, that.rogueListURL) && Objects.equals(this.rogueListHash, that.rogueListHash);
    }

    public int hashCode() {
        return Objects.hash(this.aaid, this.aaguid, this.attestationCertificateKeyIdentifiers, this.metadataStatement, this.biometricStatusReports, this.statusReports, this.timeOfLastStatusChange, this.rogueListURL, this.rogueListHash);
    }
}

