/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.metadata.MetadataBLOBProvider;
import com.webauthn4j.metadata.data.MetadataBLOB;
import java.time.LocalDate;
import org.jetbrains.annotations.NotNull;

public abstract class CachingMetadataBLOBProvider
implements MetadataBLOBProvider {
    private MetadataBLOB cachedMetadataBLOB;
    private LocalDate cachedMetadataBLOBLastUpdate = null;
    private final Object cachedMetadataBLOBLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MetadataBLOB provide() {
        Object object = this.cachedMetadataBLOBLock;
        synchronized (object) {
            if (this.cachedMetadataBLOB == null) {
                this.refresh();
            }
        }
        LocalDate today = LocalDate.now();
        LocalDate nextUpdate = this.cachedMetadataBLOB.getPayload().getNextUpdate();
        if ((nextUpdate.isBefore(today) || nextUpdate.isEqual(today)) && this.cachedMetadataBLOBLastUpdate.isBefore(today)) {
            this.refresh();
        }
        return this.cachedMetadataBLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.cachedMetadataBLOBLock;
        synchronized (object) {
            this.cachedMetadataBLOB = this.doProvide();
            this.cachedMetadataBLOBLastUpdate = LocalDate.now();
        }
    }

    @NotNull
    protected abstract MetadataBLOB doProvide();
}

