/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.converter.jackson.deserializer.MetadataAAGUIDRelaxedDeserializer;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticatorGetInfo {
    @JsonProperty(value="versions")
    private final @NonNull List<String> versions;
    @JsonProperty(value="extensions")
    private final @Nullable List<String> extensions;
    @JsonProperty(value="aaguid")
    @JsonDeserialize(using=MetadataAAGUIDRelaxedDeserializer.class)
    private final @NonNull AAGUID aaguid;
    @JsonProperty(value="options")
    private final @Nullable Options options;
    @JsonProperty(value="maxMsgSize")
    private final @Nullable Integer maxMsgSize;
    @JsonProperty(value="pinUvAuthProtocols")
    private final @Nullable List<PinProtocolVersion> pinUvAuthProtocols;

    @JsonCreator
    public AuthenticatorGetInfo(@JsonProperty(value="versions") List<String> versions, @JsonProperty(value="extensions") List<String> extensions, @JsonProperty(value="aaguid") AAGUID aaguid, @JsonProperty(value="options") Options options, @JsonProperty(value="maxMsgSize") Integer maxMsgSize, @JsonProperty(value="pinUvAuthProtocols") List<PinProtocolVersion> pinUvAuthProtocols) {
        this.versions = versions;
        this.extensions = extensions;
        this.aaguid = aaguid;
        this.options = options;
        this.maxMsgSize = maxMsgSize;
        this.pinUvAuthProtocols = pinUvAuthProtocols;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public AAGUID getAaguid() {
        return this.aaguid;
    }

    public Options getOptions() {
        return this.options;
    }

    public Integer getMaxMsgSize() {
        return this.maxMsgSize;
    }

    public List<PinProtocolVersion> getPinUvAuthProtocols() {
        return this.pinUvAuthProtocols;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorGetInfo that = (AuthenticatorGetInfo)o;
        return this.versions.equals(that.versions) && Objects.equals(this.extensions, that.extensions) && this.aaguid.equals((Object)that.aaguid) && Objects.equals(this.options, that.options) && Objects.equals(this.maxMsgSize, that.maxMsgSize) && Objects.equals(this.pinUvAuthProtocols, that.pinUvAuthProtocols);
    }

    public int hashCode() {
        return Objects.hash(this.versions, this.extensions, this.aaguid, this.options, this.maxMsgSize, this.pinUvAuthProtocols);
    }

    public static class Options {
        @JsonProperty(value="plat")
        private final PlatformOption plat;
        @JsonProperty(value="rk")
        private final ResidentKeyOption rk;
        @JsonProperty(value="clientPin")
        private final ClientPINOption clientPIN;
        @JsonProperty(value="up")
        private final UserPresenceOption up;
        @JsonProperty(value="uv")
        private final UserVerificationOption uv;
        @JsonProperty(value="uvToken")
        private final UVTokenOption uvToken;
        @JsonProperty(value="config")
        private final ConfigOption config;

        @JsonCreator
        public Options(@JsonProperty(value="plat") PlatformOption plat, @JsonProperty(value="rk") ResidentKeyOption rk, @JsonProperty(value="clientPin") ClientPINOption clientPIN, @JsonProperty(value="up") UserPresenceOption up, @JsonProperty(value="uv") UserVerificationOption uv, @JsonProperty(value="uvToken") UVTokenOption uvToken, @JsonProperty(value="config") ConfigOption config) {
            this.plat = plat;
            this.rk = rk;
            this.clientPIN = clientPIN;
            this.up = up;
            this.uv = uv;
            this.uvToken = uvToken;
            this.config = config;
        }

        public PlatformOption getPlat() {
            return this.plat;
        }

        public ResidentKeyOption getRk() {
            return this.rk;
        }

        public ClientPINOption getClientPIN() {
            return this.clientPIN;
        }

        public UserPresenceOption getUp() {
            return this.up;
        }

        public UserVerificationOption getUv() {
            return this.uv;
        }

        public UVTokenOption getUvToken() {
            return this.uvToken;
        }

        public ConfigOption getConfig() {
            return this.config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Options options = (Options)o;
            return Objects.equals(this.plat, options.plat) && Objects.equals(this.rk, options.rk) && Objects.equals(this.clientPIN, options.clientPIN) && Objects.equals(this.up, options.up) && Objects.equals(this.uv, options.uv) && Objects.equals(this.uvToken, options.uvToken) && Objects.equals(this.config, options.config);
        }

        public int hashCode() {
            return Objects.hash(this.plat, this.rk, this.clientPIN, this.up, this.uv, this.uvToken, this.config);
        }

        public static class PlatformOption {
            public static final PlatformOption PLATFORM = new PlatformOption(true);
            public static final PlatformOption CROSS_PLATFORM = new PlatformOption(false);
            public static final PlatformOption NULL = null;
            private final boolean value;

            @JsonCreator
            public PlatformOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PlatformOption that = (PlatformOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class ResidentKeyOption {
            public static final ResidentKeyOption SUPPORTED = new ResidentKeyOption(true);
            public static final ResidentKeyOption NOT_SUPPORTED = new ResidentKeyOption(false);
            public static final ResidentKeyOption NULL = null;
            private final boolean value;

            @JsonCreator
            public ResidentKeyOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ResidentKeyOption that = (ResidentKeyOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class ClientPINOption {
            public static final ClientPINOption SET = new ClientPINOption(true);
            public static final ClientPINOption NOT_SET = new ClientPINOption(false);
            public static final ClientPINOption NOT_SUPPORTED = null;
            private final boolean value;

            @JsonCreator
            public ClientPINOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ClientPINOption that = (ClientPINOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class UserPresenceOption {
            public static final UserPresenceOption SUPPORTED = new UserPresenceOption(true);
            public static final UserPresenceOption NOT_SUPPORTED = new UserPresenceOption(false);
            public static final UserPresenceOption NULL = null;
            private final boolean value;

            @JsonCreator
            public UserPresenceOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                UserPresenceOption that = (UserPresenceOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class UserVerificationOption {
            public static final UserVerificationOption READY = new UserVerificationOption(true);
            public static final UserVerificationOption NOT_READY = new UserVerificationOption(false);
            public static final UserVerificationOption NOT_SUPPORTED = null;
            private final boolean value;

            @JsonCreator
            public UserVerificationOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                UserVerificationOption that = (UserVerificationOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class UVTokenOption {
            public static final UVTokenOption SUPPORTED = new UVTokenOption(true);
            public static final UVTokenOption NOT_SUPPORTED = new UVTokenOption(false);
            public static final UVTokenOption NULL = null;
            private final boolean value;

            @JsonCreator
            public UVTokenOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                UVTokenOption that = (UVTokenOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class ConfigOption {
            public static final ConfigOption SUPPORTED = new ConfigOption(true);
            public static final ConfigOption NOT_SUPPORTED = new ConfigOption(false);
            public static final ConfigOption NULL = null;
            private final boolean value;

            @JsonCreator
            public ConfigOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ConfigOption that = (ConfigOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }
    }

    public static class PinProtocolVersion {
        public static final PinProtocolVersion VERSION_1 = new PinProtocolVersion(1);
        private final int value;

        @JsonCreator
        public PinProtocolVersion(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PinProtocolVersion that = (PinProtocolVersion)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

