/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.data.statement.MetadataStatement;
import com.webauthn4j.metadata.data.toc.BiometricStatusReport;
import com.webauthn4j.metadata.data.toc.StatusReport;
import com.webauthn4j.metadata.data.uaf.AAID;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MetadataBLOBPayloadEntry
implements Serializable {
    private final @Nullable AAID aaid;
    private final @Nullable AAGUID aaguid;
    private final @Nullable List<String> attestationCertificateKeyIdentifiers;
    private final @Nullable MetadataStatement metadataStatement;
    private final @Nullable List<BiometricStatusReport> biometricStatusReports;
    private final @NonNull List<StatusReport> statusReports;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @JsonSerialize(using=LocalDateSerializer.class)
    private final @NonNull LocalDate timeOfLastStatusChange;
    private final @Nullable String rogueListURL;
    private final @Nullable String rogueListHash;

    public MetadataBLOBPayloadEntry(@JsonProperty(value="aaid") @Nullable AAID aaid, @JsonProperty(value="aaguid") @Nullable AAGUID aaguid, @JsonProperty(value="attestationCertificateKeyIdentifiers") @Nullable List<String> attestationCertificateKeyIdentifiers, @JsonProperty(value="metadataStatement") @Nullable MetadataStatement metadataStatement, @JsonProperty(value="biometricStatusReports") @Nullable List<BiometricStatusReport> biometricStatusReports, @JsonProperty(value="statusReports") @NonNull List<StatusReport> statusReports, @JsonProperty(value="timeOfLastStatusChange") @NonNull LocalDate timeOfLastStatusChange, @JsonProperty(value="rogueListURL") @Nullable String rogueListURL, @JsonProperty(value="rogueListHash") @Nullable String rogueListHash) {
        this.aaid = aaid;
        this.aaguid = aaguid;
        this.attestationCertificateKeyIdentifiers = attestationCertificateKeyIdentifiers;
        this.metadataStatement = metadataStatement;
        this.biometricStatusReports = biometricStatusReports;
        this.statusReports = statusReports;
        this.timeOfLastStatusChange = timeOfLastStatusChange;
        this.rogueListURL = rogueListURL;
        this.rogueListHash = rogueListHash;
    }

    public @Nullable AAID getAaid() {
        return this.aaid;
    }

    public @Nullable AAGUID getAaguid() {
        return this.aaguid;
    }

    public @Nullable List<String> getAttestationCertificateKeyIdentifiers() {
        return this.attestationCertificateKeyIdentifiers;
    }

    public @Nullable MetadataStatement getMetadataStatement() {
        return this.metadataStatement;
    }

    public @Nullable List<BiometricStatusReport> getBiometricStatusReports() {
        return this.biometricStatusReports;
    }

    public @NonNull List<StatusReport> getStatusReports() {
        return this.statusReports;
    }

    public @NonNull LocalDate getTimeOfLastStatusChange() {
        return this.timeOfLastStatusChange;
    }

    public @Nullable String getRogueListURL() {
        return this.rogueListURL;
    }

    public @Nullable String getRogueListHash() {
        return this.rogueListHash;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataBLOBPayloadEntry that = (MetadataBLOBPayloadEntry)o;
        return Objects.equals(this.aaid, that.aaid) && Objects.equals(this.aaguid, that.aaguid) && Objects.equals(this.attestationCertificateKeyIdentifiers, that.attestationCertificateKeyIdentifiers) && Objects.equals(this.metadataStatement, that.metadataStatement) && Objects.equals(this.biometricStatusReports, that.biometricStatusReports) && this.statusReports.equals(that.statusReports) && this.timeOfLastStatusChange.equals(that.timeOfLastStatusChange) && Objects.equals(this.rogueListURL, that.rogueListURL) && Objects.equals(this.rogueListHash, that.rogueListHash);
    }

    public int hashCode() {
        return Objects.hash(this.aaid, this.aaguid, this.attestationCertificateKeyIdentifiers, this.metadataStatement, this.biometricStatusReports, this.statusReports, this.timeOfLastStatusChange, this.rogueListURL, this.rogueListHash);
    }
}

