/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.anchor;

import com.webauthn4j.anchor.TrustAnchorRepository;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.MetadataBLOBBasedMetadataStatementRepository;
import com.webauthn4j.metadata.MetadataBLOBProvider;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.stream.Collectors;

public class MetadataBLOBBasedTrustAnchorRepository
implements TrustAnchorRepository {
    private final MetadataBLOBBasedMetadataStatementRepository metadataBLOBBasedMetadataStatementRepository;

    public MetadataBLOBBasedTrustAnchorRepository(MetadataBLOBProvider ... metadataBLOBProviders) {
        this.metadataBLOBBasedMetadataStatementRepository = new MetadataBLOBBasedMetadataStatementRepository(metadataBLOBProviders);
    }

    public Set<TrustAnchor> find(AAGUID aaguid) {
        return this.metadataBLOBBasedMetadataStatementRepository.find(aaguid).stream().flatMap(item -> item.getAttestationRootCertificates().stream()).map(item -> new TrustAnchor((X509Certificate)item, null)).collect(Collectors.toSet());
    }

    public Set<TrustAnchor> find(byte[] attestationCertificateKeyIdentifier) {
        return this.metadataBLOBBasedMetadataStatementRepository.find(attestationCertificateKeyIdentifier).stream().flatMap(item -> item.getAttestationRootCertificates().stream()).map(item -> new TrustAnchor((X509Certificate)item, null)).collect(Collectors.toSet());
    }

    public boolean isNotFidoCertifiedAllowed() {
        return this.metadataBLOBBasedMetadataStatementRepository.isNotFidoCertifiedAllowed();
    }

    public void setNotFidoCertifiedAllowed(boolean notFidoCertifiedAllowed) {
        this.metadataBLOBBasedMetadataStatementRepository.setNotFidoCertifiedAllowed(notFidoCertifiedAllowed);
    }

    public boolean isSelfAssertionSubmittedAllowed() {
        return this.metadataBLOBBasedMetadataStatementRepository.isSelfAssertionSubmittedAllowed();
    }

    public void setSelfAssertionSubmittedAllowed(boolean selfAssertionSubmittedAllowed) {
        this.metadataBLOBBasedMetadataStatementRepository.setSelfAssertionSubmittedAllowed(selfAssertionSubmittedAllowed);
    }
}

