/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.uaf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.util.Objects;

public class AAID {
    private int v;
    private int m;

    public AAID(String aaid) {
        String[] array = aaid.split("#");
        if (array.length != 2) {
            throw new IllegalArgumentException("AAID value is not divided by single '#' separator.");
        }
        if (array[0].length() != 4) {
            throw new IllegalArgumentException("V part of AAID must consists of 4 hexadecimal digits.");
        }
        if (array[1].length() != 4) {
            throw new IllegalArgumentException("M part of AAID must consists of 4 hexadecimal digits.");
        }
        this.v = Integer.parseInt(array[0], 16);
        this.m = Integer.parseInt(array[1], 16);
    }

    @JsonCreator
    static AAID deserialize(String aaid) throws InvalidFormatException {
        try {
            return new AAID(aaid);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "invalid aaid", (Object)aaid, AAID.class);
        }
    }

    public int getV() {
        return this.v;
    }

    public int getM() {
        return this.m;
    }

    @JsonValue
    public String toString() {
        return String.format("%04X", this.v) + "#" + String.format("%04X", this.m);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AAID aaid = (AAID)o;
        return this.v == aaid.v && this.m == aaid.m;
    }

    public int hashCode() {
        return Objects.hash(this.v, this.m);
    }
}

