/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.metadata.FidoMdsMetadataItemsProvider;
import com.webauthn4j.metadata.MetadataItemsResolver;
import com.webauthn4j.metadata.MetadataItemsResolverImpl;
import com.webauthn4j.metadata.data.MetadataItem;
import com.webauthn4j.metadata.data.statement.AttestationType;
import com.webauthn4j.metadata.exception.BadStatusException;
import com.webauthn4j.validator.CustomRegistrationValidator;
import com.webauthn4j.validator.RegistrationObject;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FidoMdsMetadataValidator
implements CustomRegistrationValidator {
    private MetadataItemsResolver metadataItemsResolver;

    public FidoMdsMetadataValidator(MetadataItemsResolver metadataItemsResolver) {
        this.metadataItemsResolver = metadataItemsResolver;
    }

    public FidoMdsMetadataValidator(ObjectConverter objectConverter, String fidoMetadataServiceEndpoint) {
        FidoMdsMetadataItemsProvider metadataItemsProvider = new FidoMdsMetadataItemsProvider(objectConverter);
        metadataItemsProvider.setFidoMetadataServiceEndpoint(fidoMetadataServiceEndpoint);
        this.metadataItemsResolver = new MetadataItemsResolverImpl(metadataItemsProvider);
    }

    public FidoMdsMetadataValidator(String fidoMetadataServiceEndpoint) {
        this(new ObjectConverter(), fidoMetadataServiceEndpoint);
    }

    public void validate(RegistrationObject registrationObject) {
        CertificateBaseAttestationStatement certificateBaseAttestationStatement;
        boolean isSurrogate;
        AAGUID aaguid = registrationObject.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getAaguid();
        AttestationStatement attestationStatement = registrationObject.getAttestationObject().getAttestationStatement();
        Set<MetadataItem> metadataItems = this.metadataItemsResolver.resolve(aaguid);
        List attestationTypes = metadataItems.stream().flatMap(item -> item.getMetadataStatement().getAttestationTypes().stream()).collect(Collectors.toList());
        boolean bl = isSurrogate = !attestationTypes.isEmpty() && attestationTypes.stream().allMatch(type -> type.equals((Object)AttestationType.BASIC_SURROGATE));
        if (isSurrogate && attestationStatement instanceof CertificateBaseAttestationStatement && (certificateBaseAttestationStatement = (CertificateBaseAttestationStatement)attestationStatement).getX5c() != null) {
            throw new BadAttestationStatementException("Although AAGUID is registered for surrogate attestation in metadata, x5c contains certificates.");
        }
        for (MetadataItem metadataItem : metadataItems) {
            this.doAdditionalValidationForFidoMdsMetadataItem(metadataItem);
        }
    }

    private void doAdditionalValidationForFidoMdsMetadataItem(MetadataItem metadataItem) {
        metadataItem.getStatusReports().forEach(report -> {
            switch (report.getStatus()) {
                case FIDO_CERTIFIED: 
                case FIDO_CERTIFIED_L1: 
                case FIDO_CERTIFIED_L1_PLUS: 
                case FIDO_CERTIFIED_L2: 
                case FIDO_CERTIFIED_L2_PLUS: 
                case FIDO_CERTIFIED_L3: 
                case FIDO_CERTIFIED_L3_PLUS: 
                case UPDATE_AVAILABLE: 
                case NOT_FIDO_CERTIFIED: 
                case SELF_ASSERTION_SUBMITTED: {
                    return;
                }
            }
            throw new BadStatusException(String.format("FIDO Metadata Service reported `%s` for this authenticator.", new Object[]{report.getStatus()}));
        });
    }
}

