/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.CredentialPublicKey;
import com.webauthn4j.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class AttestedCredentialData
implements Serializable {
    private final AAGUID aaguid;
    private final byte[] credentialId;
    private final CredentialPublicKey credentialPublicKey;

    public AttestedCredentialData(AAGUID aaguid, byte[] credentialId, CredentialPublicKey credentialPublicKey) {
        this.aaguid = aaguid;
        this.credentialId = credentialId;
        this.credentialPublicKey = credentialPublicKey;
    }

    public AttestedCredentialData() {
        this.aaguid = null;
        this.credentialId = null;
        this.credentialPublicKey = null;
    }

    public AAGUID getAaguid() {
        return this.aaguid;
    }

    public byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    public CredentialPublicKey getCredentialPublicKey() {
        return this.credentialPublicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestedCredentialData that = (AttestedCredentialData)o;
        return Objects.equals(this.aaguid, that.aaguid) && Arrays.equals(this.credentialId, that.credentialId) && Objects.equals(this.credentialPublicKey, that.credentialPublicKey);
    }

    public int hashCode() {
        int result = Objects.hash(this.aaguid, this.credentialPublicKey);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        return result;
    }
}

