/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.validator.exception.CertificateException;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class AttestationCertificate
implements Serializable {
    private static final int CERTIFICATE_VERSION_3 = 3;
    private static final int NON_CA = -1;
    private X509Certificate certificate;

    public AttestationCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    static List<Rdn> getX500Name(String subjectDN) {
        try {
            return new LdapName(subjectDN).getRdns();
        }
        catch (InvalidNameException e) {
            throw new CertificateException("invalid subjectDN: " + subjectDN);
        }
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getSubjectCountry() {
        return this.getValue("C");
    }

    public String getSubjectOrganization() {
        return this.getValue("O");
    }

    public String getSubjectOrganizationUnit() {
        return this.getValue("OU");
    }

    public String getSubjectCommonName() {
        return this.getValue("CN");
    }

    public void validate() {
        if (this.certificate.getVersion() != 3) {
            throw new CertificateException("Attestation certificate must be version 3");
        }
        String country = this.getSubjectCountry();
        if (country == null || country.isEmpty()) {
            throw new CertificateException("Subject-C must be present");
        }
        String organization = this.getSubjectOrganization();
        if (organization == null || organization.isEmpty()) {
            throw new CertificateException("Subject-O must be present");
        }
        String organizationUnit = this.getSubjectOrganizationUnit();
        if (organizationUnit == null || !organizationUnit.equals("Authenticator Attestation")) {
            throw new CertificateException("Subject-OU must be present");
        }
        String commonName = this.getSubjectCommonName();
        if (commonName == null || commonName.isEmpty()) {
            throw new CertificateException("Subject-CN must be present");
        }
        if (this.certificate.getBasicConstraints() != -1) {
            throw new CertificateException("Attestation certificate must not be CA certificate");
        }
    }

    private String getValue(String name) {
        String subjectDN = this.getCertificate().getSubjectX500Principal().getName();
        return AttestationCertificate.getX500Name(subjectDN).stream().filter(rdn -> rdn.getType().equalsIgnoreCase(name)).findFirst().map(rdn -> (String)rdn.getValue()).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestationCertificate that = (AttestationCertificate)o;
        return Objects.equals(this.certificate, that.certificate);
    }

    public int hashCode() {
        return Objects.hash(this.certificate);
    }
}

