/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.converter.AuthenticationExtensionsClientOutputsConverter;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.data.WebAuthnAuthenticationContext;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.exception.WebAuthnException;
import com.webauthn4j.validator.AssertionSignatureValidator;
import com.webauthn4j.validator.AuthenticationObject;
import com.webauthn4j.validator.BeanAssertUtil;
import com.webauthn4j.validator.ChallengeValidator;
import com.webauthn4j.validator.CustomAuthenticationValidator;
import com.webauthn4j.validator.DefaultMaliciousCounterValueHandler;
import com.webauthn4j.validator.ExtensionValidator;
import com.webauthn4j.validator.MaliciousCounterValueHandler;
import com.webauthn4j.validator.OriginValidator;
import com.webauthn4j.validator.RpIdHashValidator;
import com.webauthn4j.validator.TokenBindingValidator;
import com.webauthn4j.validator.WebAuthnAuthenticationContextValidationResponse;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import com.webauthn4j.validator.exception.MaliciousDataException;
import com.webauthn4j.validator.exception.UserNotPresentException;
import com.webauthn4j.validator.exception.UserNotVerifiedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WebAuthnAuthenticationContextValidator {
    private final AuthenticatorDataConverter authenticatorDataConverter;
    private final CollectedClientDataConverter collectedClientDataConverter;
    private final AuthenticationExtensionsClientOutputsConverter authenticationExtensionsClientOutputsConverter;
    private final ChallengeValidator challengeValidator = new ChallengeValidator();
    private final OriginValidator originValidator = new OriginValidator();
    private final TokenBindingValidator tokenBindingValidator = new TokenBindingValidator();
    private final RpIdHashValidator rpIdHashValidator = new RpIdHashValidator();
    private final AssertionSignatureValidator assertionSignatureValidator = new AssertionSignatureValidator();
    private final ExtensionValidator extensionValidator = new ExtensionValidator();
    private final List<CustomAuthenticationValidator> customAuthenticationValidators = new ArrayList<CustomAuthenticationValidator>();
    private MaliciousCounterValueHandler maliciousCounterValueHandler = new DefaultMaliciousCounterValueHandler();

    public WebAuthnAuthenticationContextValidator() {
        this(new JsonConverter(), new CborConverter());
    }

    public WebAuthnAuthenticationContextValidator(JsonConverter jsonConverter, CborConverter cborConverter) {
        AssertUtil.notNull((Object)jsonConverter, (String)"jsonConverter must not be null");
        AssertUtil.notNull((Object)cborConverter, (String)"cborConverter must not be null");
        this.authenticatorDataConverter = new AuthenticatorDataConverter(cborConverter);
        this.collectedClientDataConverter = new CollectedClientDataConverter(jsonConverter);
        this.authenticationExtensionsClientOutputsConverter = new AuthenticationExtensionsClientOutputsConverter(jsonConverter);
    }

    public WebAuthnAuthenticationContextValidationResponse validate(WebAuthnAuthenticationContext authenticationContext, Authenticator authenticator) throws WebAuthnException {
        BeanAssertUtil.validate(authenticationContext);
        byte[] credentialId = authenticationContext.getCredentialId();
        byte[] cData = authenticationContext.getClientDataJSON();
        byte[] aData = authenticationContext.getAuthenticatorData();
        CollectedClientData collectedClientData = this.collectedClientDataConverter.convert(cData);
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = this.authenticatorDataConverter.convert(aData);
        AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions = this.authenticationExtensionsClientOutputsConverter.convert(authenticationContext.getClientExtensionsJSON());
        ServerProperty serverProperty = authenticationContext.getServerProperty();
        BeanAssertUtil.validate(collectedClientData);
        BeanAssertUtil.validate(authenticatorData);
        BeanAssertUtil.validate(serverProperty);
        this.validateAuthenticatorData(authenticatorData);
        AuthenticationObject authenticationObject = new AuthenticationObject(credentialId, collectedClientData, cData, authenticatorData, aData, clientExtensions, authenticationContext.getServerProperty());
        if (!Objects.equals((Object)collectedClientData.getType(), (Object)ClientDataType.GET)) {
            throw new MaliciousDataException("ClientData.type must be 'get' on authentication, but it isn't.");
        }
        this.challengeValidator.validate(collectedClientData, serverProperty);
        this.originValidator.validate(collectedClientData, serverProperty);
        this.tokenBindingValidator.validate(collectedClientData.getTokenBinding(), serverProperty.getTokenBindingId());
        this.rpIdHashValidator.validate(authenticatorData.getRpIdHash(), serverProperty);
        if (authenticationContext.isUserVerificationRequired() && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Validator is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        if (authenticationContext.isUserPresenceRequired() && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Validator is configured to check user present, but UP flag in authenticatorData is not set.");
        }
        AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        List expectedExtensionIdentifiers = authenticationContext.getExpectedExtensionIds();
        this.extensionValidator.validate(clientExtensions, authenticationExtensionsAuthenticatorOutputs, expectedExtensionIdentifiers);
        this.assertionSignatureValidator.validate(authenticationContext, authenticator.getAttestedCredentialData().getCredentialPublicKey());
        long presentedCounter = authenticatorData.getSignCount();
        long storedCounter = authenticator.getCounter();
        if (presentedCounter > 0L || storedCounter > 0L) {
            if (presentedCounter > storedCounter) {
                authenticator.setCounter(presentedCounter);
            } else {
                this.maliciousCounterValueHandler.maliciousCounterValueDetected(authenticationContext, authenticator);
            }
        }
        for (CustomAuthenticationValidator customAuthenticationValidator : this.customAuthenticationValidators) {
            customAuthenticationValidator.validate(authenticationObject);
        }
        return new WebAuthnAuthenticationContextValidationResponse(collectedClientData, authenticatorData, clientExtensions);
    }

    void validateAuthenticatorData(AuthenticatorData authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() != null) {
            throw new ConstraintViolationException("attestedCredentialData must be null on authentication");
        }
    }

    public MaliciousCounterValueHandler getMaliciousCounterValueHandler() {
        return this.maliciousCounterValueHandler;
    }

    public void setMaliciousCounterValueHandler(MaliciousCounterValueHandler maliciousCounterValueHandler) {
        AssertUtil.notNull((Object)maliciousCounterValueHandler, (String)"maliciousCounterValueHandler must not be null");
        this.maliciousCounterValueHandler = maliciousCounterValueHandler;
    }

    public List<CustomAuthenticationValidator> getCustomAuthenticationValidators() {
        return this.customAuthenticationValidators;
    }
}

