/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.validator.exception.UnexpectedExtensionException;
import java.util.Collections;
import java.util.List;

class ExtensionValidator {
    ExtensionValidator() {
    }

    public <A extends ExtensionAuthenticatorOutput, C extends ExtensionClientOutput> void validate(AuthenticationExtensionsClientOutputs<C> authenticationExtensionsClientOutputs, AuthenticationExtensionsAuthenticatorOutputs<A> authenticationExtensionsAuthenticatorOutputs, List<String> expectedExtensionIdentifiers) {
        List<Object> expected = expectedExtensionIdentifiers == null ? Collections.emptyList() : expectedExtensionIdentifiers;
        if (authenticationExtensionsClientOutputs != null) {
            authenticationExtensionsClientOutputs.keySet().forEach(identifier -> {
                if (!expected.contains(identifier)) {
                    throw new UnexpectedExtensionException(String.format("Unexpected client extension '%s' is contained", identifier));
                }
            });
        }
        if (authenticationExtensionsAuthenticatorOutputs != null) {
            authenticationExtensionsAuthenticatorOutputs.keySet().forEach(identifier -> {
                if (!expected.contains(identifier)) {
                    throw new UnexpectedExtensionException(String.format("Unexpected authenticator extension '%s' is contained", identifier));
                }
            });
        }
    }
}

