/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.webauthn4j.converter.jackson.deserializer.AuthenticationExtensionsAuthenticatorOutputsEnvelope;
import com.webauthn4j.converter.jackson.deserializer.AuthenticationExtensionsAuthenticatorOutputsEnvelopeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.AuthenticatorDataDeserializer;
import com.webauthn4j.converter.jackson.deserializer.CertPathDeserializer;
import com.webauthn4j.converter.jackson.deserializer.ChallengeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.CredentialPublicKeyEnvelope;
import com.webauthn4j.converter.jackson.deserializer.CredentialPublicKeyEnvelopeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.ExtensionAuthenticatorOutputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.JWSDeserializer;
import com.webauthn4j.converter.jackson.deserializer.TPMSAttestDeserializer;
import com.webauthn4j.converter.jackson.deserializer.TPMTPublicDeserializer;
import com.webauthn4j.converter.jackson.deserializer.X509CertificateDeserializer;
import com.webauthn4j.converter.jackson.serializer.AuthenticatorDataSerializer;
import com.webauthn4j.converter.jackson.serializer.CertPathSerializer;
import com.webauthn4j.converter.jackson.serializer.ChallengeSerializer;
import com.webauthn4j.converter.jackson.serializer.JWSSerializer;
import com.webauthn4j.converter.jackson.serializer.OriginSerializer;
import com.webauthn4j.converter.jackson.serializer.TPMSAttestSerializer;
import com.webauthn4j.converter.jackson.serializer.TPMTPublicSerializer;
import com.webauthn4j.converter.jackson.serializer.X509CertificateSerializer;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.statement.AndroidKeyAttestationStatement;
import com.webauthn4j.data.attestation.statement.AndroidSafetyNetAttestationStatement;
import com.webauthn4j.data.attestation.statement.FIDOU2FAttestationStatement;
import com.webauthn4j.data.attestation.statement.NoneAttestationStatement;
import com.webauthn4j.data.attestation.statement.PackedAttestationStatement;
import com.webauthn4j.data.attestation.statement.TPMAttestationStatement;
import com.webauthn4j.data.attestation.statement.TPMSAttest;
import com.webauthn4j.data.attestation.statement.TPMTPublic;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.GenericTransactionAuthorizationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.LocationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.SimpleTransactionAuthorizationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.SupportedExtensionsExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.UserVerificationIndexExtensionAuthenticatorOutput;
import com.webauthn4j.data.jws.JWS;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;

public class WebAuthnCBORModule
extends SimpleModule {
    public WebAuthnCBORModule(JsonConverter jsonConverter, CborConverter cborConverter) {
        super("WebAuthnCBORModule");
        this.addDeserializer(AuthenticationExtensionsAuthenticatorOutputsEnvelope.class, (JsonDeserializer)new AuthenticationExtensionsAuthenticatorOutputsEnvelopeDeserializer());
        this.addDeserializer(CertPath.class, (JsonDeserializer)new CertPathDeserializer());
        this.addDeserializer(Challenge.class, (JsonDeserializer)new ChallengeDeserializer());
        this.addDeserializer(CredentialPublicKeyEnvelope.class, (JsonDeserializer)new CredentialPublicKeyEnvelopeDeserializer());
        this.addDeserializer(AuthenticatorData.class, (JsonDeserializer)new AuthenticatorDataDeserializer(cborConverter));
        this.addDeserializer(ExtensionAuthenticatorOutput.class, (JsonDeserializer)new ExtensionAuthenticatorOutputDeserializer());
        this.addDeserializer(TPMSAttest.class, (JsonDeserializer)new TPMSAttestDeserializer());
        this.addDeserializer(TPMTPublic.class, (JsonDeserializer)new TPMTPublicDeserializer());
        this.addDeserializer(X509Certificate.class, (JsonDeserializer)new X509CertificateDeserializer());
        this.addDeserializer(JWS.class, (JsonDeserializer)new JWSDeserializer(jsonConverter));
        this.addSerializer(AuthenticatorData.class, (JsonSerializer)new AuthenticatorDataSerializer(cborConverter));
        this.addSerializer(CertPath.class, (JsonSerializer)new CertPathSerializer());
        this.addSerializer(Challenge.class, (JsonSerializer)new ChallengeSerializer());
        this.addSerializer(JWS.class, (JsonSerializer)new JWSSerializer());
        this.addSerializer(Origin.class, (JsonSerializer)new OriginSerializer());
        this.addSerializer(TPMSAttest.class, (JsonSerializer)new TPMSAttestSerializer());
        this.addSerializer(TPMTPublic.class, (JsonSerializer)new TPMTPublicSerializer());
        this.addSerializer(X509Certificate.class, (JsonSerializer)new X509CertificateSerializer());
        this.registerSubtypes(new NamedType[]{new NamedType(FIDOU2FAttestationStatement.class, "fido-u2f")});
        this.registerSubtypes(new NamedType[]{new NamedType(PackedAttestationStatement.class, "packed")});
        this.registerSubtypes(new NamedType[]{new NamedType(AndroidKeyAttestationStatement.class, "android-key")});
        this.registerSubtypes(new NamedType[]{new NamedType(AndroidSafetyNetAttestationStatement.class, "android-safetynet")});
        this.registerSubtypes(new NamedType[]{new NamedType(TPMAttestationStatement.class, "tpm")});
        this.registerSubtypes(new NamedType[]{new NamedType(NoneAttestationStatement.class, "none")});
        this.registerSubtypes(new NamedType[]{new NamedType(GenericTransactionAuthorizationExtensionAuthenticatorOutput.class, "txAuthGeneric")});
        this.registerSubtypes(new NamedType[]{new NamedType(LocationExtensionAuthenticatorOutput.class, "loc")});
        this.registerSubtypes(new NamedType[]{new NamedType(SimpleTransactionAuthorizationExtensionAuthenticatorOutput.class, "txAuthSimple")});
        this.registerSubtypes(new NamedType[]{new NamedType(SupportedExtensionsExtensionAuthenticatorOutput.class, "exts")});
        this.registerSubtypes(new NamedType[]{new NamedType(UserVerificationIndexExtensionAuthenticatorOutput.class, "uvi")});
    }
}

