/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.authenticator;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class AuthenticatorImpl
implements Authenticator {
    private AttestedCredentialData attestedCredentialData;
    private AttestationStatement attestationStatement;
    private Set<AuthenticatorTransport> transports;
    private long counter;

    public AuthenticatorImpl(AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement, long counter, Set<AuthenticatorTransport> transports) {
        this.attestedCredentialData = attestedCredentialData;
        this.attestationStatement = attestationStatement;
        this.transports = Collections.unmodifiableSet(transports);
        this.setCounter(counter);
    }

    public AuthenticatorImpl(AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement, long counter) {
        this(attestedCredentialData, attestationStatement, counter, Collections.emptySet());
    }

    @Override
    public AttestedCredentialData getAttestedCredentialData() {
        return this.attestedCredentialData;
    }

    public void setAttestedCredentialData(AttestedCredentialData attestedCredentialData) {
        this.attestedCredentialData = attestedCredentialData;
    }

    @Override
    public AttestationStatement getAttestationStatement() {
        return this.attestationStatement;
    }

    public void setAttestationStatement(AttestationStatement attestationStatement) {
        this.attestationStatement = attestationStatement;
    }

    @Override
    public long getCounter() {
        return this.counter;
    }

    @Override
    public void setCounter(long value) {
        if (value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("[Assertion failed] - this argument is unsigned int. it must not exceed 4294967295.");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("[Assertion failed] - this argument is unsigned int. it must not be negative value.");
        }
        this.counter = value;
    }

    @Override
    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public void setTransports(Set<AuthenticatorTransport> transports) {
        this.transports = transports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorImpl that = (AuthenticatorImpl)o;
        return this.counter == that.counter && Objects.equals(this.attestedCredentialData, that.attestedCredentialData) && Objects.equals(this.attestationStatement, that.attestationStatement) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        return Objects.hash(this.attestedCredentialData, this.attestationStatement, this.transports, this.counter);
    }
}

