/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.AuthenticationExtensionsClientOutputsConverter;
import com.webauthn4j.converter.AuthenticatorTransportConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.WebAuthnRegistrationContext;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.exception.WebAuthnException;
import com.webauthn4j.validator.AttestationValidator;
import com.webauthn4j.validator.BeanAssertUtil;
import com.webauthn4j.validator.ChallengeValidator;
import com.webauthn4j.validator.CustomRegistrationValidator;
import com.webauthn4j.validator.ExtensionValidator;
import com.webauthn4j.validator.OriginValidator;
import com.webauthn4j.validator.RegistrationObject;
import com.webauthn4j.validator.RpIdHashValidator;
import com.webauthn4j.validator.TokenBindingValidator;
import com.webauthn4j.validator.WebAuthnRegistrationContextValidationResponse;
import com.webauthn4j.validator.attestation.statement.AttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidkey.NullAndroidKeyAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidsafetynet.NullAndroidSafetyNetAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.none.NoneAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.packed.NullPackedAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.u2f.NullFIDOU2FAttestationStatementValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.NullCertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.ecdaa.ECDAATrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.ecdaa.NullECDAATrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.DefaultSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.NullSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import com.webauthn4j.validator.exception.MaliciousDataException;
import com.webauthn4j.validator.exception.UserNotPresentException;
import com.webauthn4j.validator.exception.UserNotVerifiedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class WebAuthnRegistrationContextValidator {
    private final CollectedClientDataConverter collectedClientDataConverter;
    private final AttestationObjectConverter attestationObjectConverter;
    private final AuthenticatorTransportConverter authenticatorTransportConverter;
    private final AuthenticationExtensionsClientOutputsConverter authenticationExtensionsClientOutputsConverter;
    private final ChallengeValidator challengeValidator = new ChallengeValidator();
    private final OriginValidator originValidator = new OriginValidator();
    private final TokenBindingValidator tokenBindingValidator = new TokenBindingValidator();
    private final RpIdHashValidator rpIdHashValidator = new RpIdHashValidator();
    private final ExtensionValidator extensionValidator = new ExtensionValidator();
    private final List<CustomRegistrationValidator> customRegistrationValidators = new ArrayList<CustomRegistrationValidator>();
    private final AttestationValidator attestationValidator;

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, new DefaultSelfAttestationTrustworthinessValidator(), new JsonConverter(), new CborConverter());
    }

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, selfAttestationTrustworthinessValidator, new JsonConverter(), new CborConverter());
    }

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, JsonConverter jsonConverter, CborConverter cborConverter) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, new DefaultSelfAttestationTrustworthinessValidator(), jsonConverter, cborConverter);
    }

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator, JsonConverter jsonConverter, CborConverter cborConverter) {
        AssertUtil.notNull(attestationStatementValidators, (String)"attestationStatementValidators must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessValidator, (String)"certPathTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)ecdaaTrustworthinessValidator, (String)"ecdaaTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessValidator, (String)"selfAttestationTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)jsonConverter, (String)"jsonConverter must not be null");
        AssertUtil.notNull((Object)cborConverter, (String)"cborConverter must not be null");
        this.collectedClientDataConverter = new CollectedClientDataConverter(jsonConverter);
        this.attestationObjectConverter = new AttestationObjectConverter(cborConverter);
        this.authenticatorTransportConverter = new AuthenticatorTransportConverter();
        this.authenticationExtensionsClientOutputsConverter = new AuthenticationExtensionsClientOutputsConverter(jsonConverter);
        this.attestationValidator = new AttestationValidator(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, selfAttestationTrustworthinessValidator);
    }

    public static WebAuthnRegistrationContextValidator createNonStrictRegistrationContextValidator() {
        return WebAuthnRegistrationContextValidator.createNonStrictRegistrationContextValidator(new JsonConverter(), new CborConverter());
    }

    public static WebAuthnRegistrationContextValidator createNonStrictRegistrationContextValidator(JsonConverter jsonConverter, CborConverter cborConverter) {
        return new WebAuthnRegistrationContextValidator(Arrays.asList(new NoneAttestationStatementValidator(), new NullFIDOU2FAttestationStatementValidator(), new NullPackedAttestationStatementValidator(), new NullAndroidKeyAttestationStatementValidator(), new NullAndroidSafetyNetAttestationStatementValidator()), new NullCertPathTrustworthinessValidator(), new NullECDAATrustworthinessValidator(), new NullSelfAttestationTrustworthinessValidator(), jsonConverter, cborConverter);
    }

    public WebAuthnRegistrationContextValidationResponse validate(WebAuthnRegistrationContext registrationContext) throws WebAuthnException {
        BeanAssertUtil.validate(registrationContext);
        byte[] clientDataBytes = registrationContext.getClientDataJSON();
        byte[] attestationObjectBytes = registrationContext.getAttestationObject();
        CollectedClientData collectedClientData = this.collectedClientDataConverter.convert(clientDataBytes);
        AttestationObject attestationObject = this.attestationObjectConverter.convert(attestationObjectBytes);
        Set<AuthenticatorTransport> transports = this.authenticatorTransportConverter.convertSet(registrationContext.getTransports());
        AuthenticationExtensionsClientOutputs<ExtensionClientOutput> clientExtensions = this.authenticationExtensionsClientOutputsConverter.convert(registrationContext.getClientExtensionsJSON());
        BeanAssertUtil.validate(collectedClientData);
        BeanAssertUtil.validate(attestationObject);
        BeanAssertUtil.validateAuthenticationExtensionsClientOutputs(clientExtensions);
        this.validateAuthenticatorDataField(attestationObject.getAuthenticatorData());
        byte[] authenticatorDataBytes = this.attestationObjectConverter.extractAuthenticatorData(attestationObjectBytes);
        RegistrationObject registrationObject = new RegistrationObject(collectedClientData, clientDataBytes, attestationObject, attestationObjectBytes, authenticatorDataBytes, transports, clientExtensions, registrationContext.getServerProperty());
        AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData = attestationObject.getAuthenticatorData();
        ServerProperty serverProperty = registrationContext.getServerProperty();
        if (!Objects.equals((Object)collectedClientData.getType(), (Object)ClientDataType.CREATE)) {
            throw new MaliciousDataException("ClientData.type must be 'create' on registration, but it isn't.");
        }
        this.challengeValidator.validate(collectedClientData, serverProperty);
        this.originValidator.validate(collectedClientData, serverProperty);
        this.tokenBindingValidator.validate(collectedClientData.getTokenBinding(), serverProperty.getTokenBindingId());
        this.rpIdHashValidator.validate(authenticatorData.getRpIdHash(), serverProperty);
        this.validateUVUPFlags(authenticatorData, registrationContext.isUserVerificationRequired(), registrationContext.isUserPresenceRequired());
        AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        List expectedExtensionIdentifiers = registrationContext.getExpectedExtensionIds();
        this.extensionValidator.validate(clientExtensions, authenticationExtensionsAuthenticatorOutputs, expectedExtensionIdentifiers);
        this.attestationValidator.validate(registrationObject);
        for (CustomRegistrationValidator customRegistrationValidator : this.customRegistrationValidators) {
            customRegistrationValidator.validate(registrationObject);
        }
        return new WebAuthnRegistrationContextValidationResponse(collectedClientData, attestationObject, clientExtensions);
    }

    void validateAuthenticatorDataField(AuthenticatorData authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() == null) {
            throw new ConstraintViolationException("attestedCredentialData must not be null on registration");
        }
    }

    void validateUVUPFlags(AuthenticatorData authenticatorData, boolean isUserVerificationRequired, boolean isUserPresenceRequired) {
        if (isUserVerificationRequired && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Validator is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        if (isUserPresenceRequired && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Validator is configured to check user present, but UP flag in authenticatorData is not set.");
        }
    }

    public List<CustomRegistrationValidator> getCustomRegistrationValidators() {
        return this.customRegistrationValidators;
    }
}

