/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum AuthenticatorTransport {
    USB("usb"),
    NFC("nfc"),
    BLE("ble");

    private String value;

    private AuthenticatorTransport(String value) {
        this.value = value;
    }

    public static AuthenticatorTransport create(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "usb": {
                return USB;
            }
            case "nfc": {
                return NFC;
            }
            case "ble": {
                return BLE;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static AuthenticatorTransport fromJson(String value) throws InvalidFormatException {
        try {
            return AuthenticatorTransport.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AuthenticatorTransport.class);
        }
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

