/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.exception.BadOriginException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OriginValidator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    OriginValidator() {
    }

    public void validate(CollectedClientData collectedClientData, ServerProperty serverProperty) {
        AssertUtil.notNull((Object)collectedClientData, (String)"collectedClientData must not be null");
        AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
        if (!Objects.equals(collectedClientData.getOrigin(), serverProperty.getOrigin())) {
            this.logger.debug("Authentication failed: bad origin is specified");
            throw new BadOriginException("Preconfigured server origin and collected clientData origin is not same.");
        }
    }
}

