/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.ArrayUtil;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Objects;

public class AuthenticationObject {
    private final byte[] credentialId;
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData;
    private final byte[] authenticatorDataBytes;
    private final AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions;
    private final ServerProperty serverProperty;
    private final Authenticator authenticator;
    private final LocalDateTime timestamp;

    public AuthenticationObject(byte[] credentialId, CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData, byte[] authenticatorDataBytes, AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions, ServerProperty serverProperty, Authenticator authenticator) {
        this(credentialId, collectedClientData, collectedClientDataBytes, authenticatorData, authenticatorDataBytes, clientExtensions, serverProperty, authenticator, LocalDateTime.now(Clock.systemUTC()));
    }

    public AuthenticationObject(byte[] credentialId, CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData, byte[] authenticatorDataBytes, AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions, ServerProperty serverProperty, Authenticator authenticator, LocalDateTime timestamp) {
        this.credentialId = credentialId;
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = collectedClientDataBytes;
        this.authenticatorData = authenticatorData;
        this.authenticatorDataBytes = authenticatorDataBytes;
        this.clientExtensions = clientExtensions;
        this.serverProperty = serverProperty;
        this.authenticator = authenticator;
        this.timestamp = timestamp;
    }

    public byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    public CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    public byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone((byte[])this.collectedClientDataBytes);
    }

    public AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> getAuthenticatorData() {
        return this.authenticatorData;
    }

    public byte[] getAuthenticatorDataBytes() {
        return ArrayUtil.clone((byte[])this.authenticatorDataBytes);
    }

    public AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationObject that = (AuthenticationObject)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Objects.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.collectedClientDataBytes, that.collectedClientDataBytes) && Objects.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.authenticatorDataBytes, that.authenticatorDataBytes) && Objects.equals(this.clientExtensions, that.clientExtensions) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.authenticator, that.authenticator) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        int result = Objects.hash(this.collectedClientData, this.authenticatorData, this.clientExtensions, this.serverProperty, this.authenticator, this.timestamp);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        result = 31 * result + Arrays.hashCode(this.collectedClientDataBytes);
        result = 31 * result + Arrays.hashCode(this.authenticatorDataBytes);
        return result;
    }
}

