/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum ClientDataType {
    CREATE("webauthn.create"),
    GET("webauthn.get");

    private String value;

    private ClientDataType(String value) {
        this.value = value;
    }

    public static ClientDataType create(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "webauthn.create": {
                return CREATE;
            }
            case "webauthn.get": {
                return GET;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static ClientDataType deserialize(String value) throws InvalidFormatException {
        try {
            return ClientDataType.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, ClientDataType.class);
        }
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

