/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ConverterUtil;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public class CborConverter {
    private static final String INPUT_MISMATCH_ERROR_MESSAGE = "Input data does not match expected form";
    private ObjectMapper cborMapper;
    private JsonConverter jsonConverter;

    CborConverter(ObjectMapper jsonMapper, ObjectMapper cborMapper, JsonConverter jsonConverter) {
        AssertUtil.notNull((Object)jsonMapper, (String)"jsonMapper must not be null");
        AssertUtil.notNull((Object)cborMapper, (String)"cborMapper must not be null");
        AssertUtil.isTrue((!(jsonMapper.getFactory() instanceof CBORFactory) ? 1 : 0) != 0, (String)"factory of jsonMapper must be JsonFactory.");
        AssertUtil.isTrue((boolean)(cborMapper.getFactory() instanceof CBORFactory), (String)"factory of cborMapper must be CBORFactory.");
        this.cborMapper = cborMapper;
        this.jsonConverter = jsonConverter;
        if (this.jsonConverter == null) {
            this.jsonConverter = new JsonConverter(jsonMapper, cborMapper, this);
            ConverterUtil.initializeJsonMapper(jsonMapper, this.jsonConverter, this);
            ConverterUtil.initializeCborMapper(cborMapper, this.jsonConverter, this);
        }
    }

    public CborConverter(ObjectMapper jsonMapper, ObjectMapper cborMapper) {
        this(jsonMapper, cborMapper, null);
    }

    public CborConverter() {
        this(new ObjectMapper(), new ObjectMapper((JsonFactory)new CBORFactory()));
    }

    public <T> T readValue(byte[] src, Class valueType) {
        try {
            return (T)this.cborMapper.readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(InputStream src, Class valueType) {
        try {
            return (T)this.cborMapper.readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(byte[] src, TypeReference valueTypeRef) {
        try {
            return (T)this.cborMapper.readValue(src, valueTypeRef);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public AuthenticationExtensionsAuthenticatorOutputs readValue(InputStream inputStream, TypeReference<AuthenticationExtensionsAuthenticatorOutputs> typeReference) {
        try {
            return (AuthenticationExtensionsAuthenticatorOutputs)this.cborMapper.readValue(inputStream, typeReference);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonNode readTree(byte[] bytes) {
        try {
            return this.cborMapper.readTree(bytes);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] writeValueAsBytes(Object value) {
        try {
            return this.cborMapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }
}

