/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.statement.u2f;

import com.webauthn4j.response.attestation.AttestationObject;
import com.webauthn4j.response.attestation.authenticator.EC2CredentialPublicKey;
import com.webauthn4j.response.attestation.statement.AttestationStatement;
import com.webauthn4j.response.attestation.statement.AttestationType;
import com.webauthn4j.response.attestation.statement.FIDOU2FAttestationStatement;
import com.webauthn4j.util.ECUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.RegistrationObject;
import com.webauthn4j.validator.attestation.statement.AttestationStatementValidator;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import com.webauthn4j.validator.exception.BadSignatureException;
import com.webauthn4j.validator.exception.CertificateException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;

public class FIDOU2FAttestationStatementValidator
implements AttestationStatementValidator {
    @Override
    public AttestationType validate(RegistrationObject registrationObject) {
        if (!this.supports(registrationObject)) {
            throw new IllegalArgumentException("Specified format is not supported by " + this.getClass().getName());
        }
        FIDOU2FAttestationStatement attestationStatement = (FIDOU2FAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        this.validateAttestationStatement(attestationStatement);
        this.validateSignature(registrationObject);
        return AttestationType.BASIC;
    }

    void validateAttestationStatement(FIDOU2FAttestationStatement attestationStatement) {
        if (attestationStatement.getX5c().size() != 1) {
            throw new BadAttestationStatementException("FIDO-U2F attestation statement must have only one certificate.");
        }
        PublicKey publicKey = attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate().getPublicKey();
        this.validatePublicKey(publicKey);
    }

    void validatePublicKey(PublicKey publicKey) {
        if (!publicKey.getAlgorithm().equals("EC")) {
            throw new CertificateException("FIDO-U2F attestation statement supports ECDSA only.");
        }
        if (!((ECPublicKey)publicKey).getParams().equals(ECUtil.P_256_SPEC)) {
            throw new CertificateException("FIDO-U2F attestation statement supports secp256r1 curve only.");
        }
    }

    private void validateSignature(RegistrationObject registrationObject) {
        FIDOU2FAttestationStatement attestationStatement = (FIDOU2FAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        byte[] signedData = this.getSignedData(registrationObject);
        byte[] signature = attestationStatement.getSig();
        PublicKey publicKey = this.getPublicKey(attestationStatement);
        try {
            Signature verifier = Signature.getInstance("SHA256withECDSA");
            verifier.initVerify(publicKey);
            verifier.update(signedData);
            if (verifier.verify(signature)) {
                return;
            }
            throw new BadSignatureException("Bad signature");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new BadSignatureException("Bad signature", e);
        }
    }

    @Override
    public boolean supports(RegistrationObject registrationObject) {
        AttestationStatement attestationStatement = registrationObject.getAttestationObject().getAttestationStatement();
        return FIDOU2FAttestationStatement.class.isAssignableFrom(attestationStatement.getClass());
    }

    private byte[] getSignedData(RegistrationObject registrationObject) {
        String rpId = registrationObject.getServerProperty().getRpId();
        MessageDigest messageDigest = MessageDigestUtil.createSHA256();
        AttestationObject attestationObject = registrationObject.getAttestationObject();
        EC2CredentialPublicKey credentialPublicKey = (EC2CredentialPublicKey)attestationObject.getAuthenticatorData().getAttestedCredentialData().getCredentialPublicKey();
        byte[] rpIdBytes = rpId.getBytes(StandardCharsets.UTF_8);
        byte[] clientDataJsonBytes = registrationObject.getCollectedClientDataBytes();
        byte[] applicationParameter = messageDigest.digest(rpIdBytes);
        byte[] challengeParameter = messageDigest.digest(clientDataJsonBytes);
        byte[] keyHandle = attestationObject.getAuthenticatorData().getAttestedCredentialData().getCredentialId();
        byte[] userPublicKeyBytes = credentialPublicKey.getBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate(65 + keyHandle.length + 65);
        byteBuffer.put((byte)0);
        byteBuffer.put(applicationParameter);
        byteBuffer.put(challengeParameter);
        byteBuffer.put(keyHandle);
        byteBuffer.put(userPublicKeyBytes);
        return byteBuffer.array();
    }

    private PublicKey getPublicKey(FIDOU2FAttestationStatement attestationStatement) {
        X509Certificate cert = attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate();
        return cert.getPublicKey();
    }
}

