/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response;

import com.webauthn4j.request.AuthenticatorTransport;
import com.webauthn4j.response.AuthenticatorResponse;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AuthenticatorAttestationResponse
extends AuthenticatorResponse {
    private byte[] attestationObject;
    private List<AuthenticatorTransport> authenticatorTransports;

    public AuthenticatorAttestationResponse(byte[] clientDataJSON, byte[] attestationObject) {
        this(clientDataJSON, attestationObject, Collections.emptyList());
    }

    public AuthenticatorAttestationResponse(byte[] clientDataJSON, byte[] attestationObject, List<AuthenticatorTransport> authenticatorTransports) {
        super(clientDataJSON);
        List sorted = authenticatorTransports.stream().sorted((left, right) -> left.getValue().compareToIgnoreCase(right.getValue())).collect(Collectors.toList());
        this.attestationObject = attestationObject;
        this.authenticatorTransports = CollectionUtil.unmodifiableList(sorted);
    }

    public byte[] getAttestationObject() {
        return ArrayUtil.clone((byte[])this.attestationObject);
    }

    public List<AuthenticatorTransport> getAuthenticatorTransports() {
        return this.authenticatorTransports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorAttestationResponse that = (AuthenticatorAttestationResponse)o;
        return Arrays.equals(this.attestationObject, that.attestationObject) && Objects.equals(this.authenticatorTransports, that.authenticatorTransports);
    }

    public int hashCode() {
        int result = Objects.hash(this.authenticatorTransports);
        result = 31 * result + Arrays.hashCode(this.attestationObject);
        return result;
    }
}

