/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.request.AttestationConveyancePreference;
import com.webauthn4j.request.AuthenticatorSelectionCriteria;
import com.webauthn4j.request.PublicKeyCredentialDescriptor;
import com.webauthn4j.request.PublicKeyCredentialParameters;
import com.webauthn4j.request.PublicKeyCredentialRpEntity;
import com.webauthn4j.request.PublicKeyCredentialUserEntity;
import com.webauthn4j.request.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.request.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.response.client.challenge.Challenge;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PublicKeyCredentialCreationOptions
implements Serializable {
    private PublicKeyCredentialRpEntity rp;
    private PublicKeyCredentialUserEntity user;
    private Challenge challenge;
    private List<PublicKeyCredentialParameters> pubKeyCredParams = Collections.emptyList();
    private BigInteger timeout;
    private List<PublicKeyCredentialDescriptor> excludeCredentials = Collections.emptyList();
    private AuthenticatorSelectionCriteria authenticatorSelection;
    private AttestationConveyancePreference attestation;
    private AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions;

    @JsonCreator
    public PublicKeyCredentialCreationOptions(@JsonProperty(value="rp") PublicKeyCredentialRpEntity rp, @JsonProperty(value="user") PublicKeyCredentialUserEntity user, @JsonProperty(value="challenge") Challenge challenge, @JsonProperty(value="pubKeyCredParams") List<PublicKeyCredentialParameters> pubKeyCredParams, @JsonProperty(value="timeout") BigInteger timeout, @JsonProperty(value="excludeCredentials") List<PublicKeyCredentialDescriptor> excludeCredentials, @JsonProperty(value="authenticatorSelection") AuthenticatorSelectionCriteria authenticatorSelection, @JsonProperty(value="attestation") AttestationConveyancePreference attestation, @JsonProperty(value="extensions") AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions) {
        this.rp = rp;
        this.user = user;
        this.challenge = challenge;
        this.pubKeyCredParams = CollectionUtil.unmodifiableList(pubKeyCredParams);
        this.timeout = timeout;
        this.excludeCredentials = CollectionUtil.unmodifiableList(excludeCredentials);
        this.authenticatorSelection = authenticatorSelection;
        this.attestation = attestation;
        this.extensions = extensions;
    }

    public PublicKeyCredentialCreationOptions(PublicKeyCredentialRpEntity rp, PublicKeyCredentialUserEntity user, Challenge challenge, List<PublicKeyCredentialParameters> pubKeyCredParams) {
        this(rp, user, challenge, pubKeyCredParams, null, Collections.emptyList(), null, null, null);
    }

    public PublicKeyCredentialRpEntity getRp() {
        return this.rp;
    }

    public PublicKeyCredentialUserEntity getUser() {
        return this.user;
    }

    public Challenge getChallenge() {
        return this.challenge;
    }

    public List<PublicKeyCredentialParameters> getPubKeyCredParams() {
        return this.pubKeyCredParams;
    }

    public BigInteger getTimeout() {
        return this.timeout;
    }

    public List<PublicKeyCredentialDescriptor> getExcludeCredentials() {
        return this.excludeCredentials;
    }

    public AuthenticatorSelectionCriteria getAuthenticatorSelection() {
        return this.authenticatorSelection;
    }

    public AttestationConveyancePreference getAttestation() {
        return this.attestation;
    }

    public AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialCreationOptions that = (PublicKeyCredentialCreationOptions)o;
        return Objects.equals(this.rp, that.rp) && Objects.equals(this.user, that.user) && Objects.equals(this.challenge, that.challenge) && Objects.equals(this.pubKeyCredParams, that.pubKeyCredParams) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.excludeCredentials, that.excludeCredentials) && Objects.equals(this.authenticatorSelection, that.authenticatorSelection) && this.attestation == that.attestation && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rp, this.user, this.challenge, this.pubKeyCredParams, this.timeout, this.excludeCredentials, this.authenticatorSelection, this.attestation, this.extensions});
    }
}

