/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util.jws;

import com.fasterxml.jackson.core.ObjectCodec;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.SignatureUtil;
import com.webauthn4j.util.jws.JWSHeader;
import com.webauthn4j.util.jws.JWSSignatureUtil;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWS<T extends Serializable>
implements Serializable {
    transient Logger logger = LoggerFactory.getLogger(JWS.class);
    private JWSHeader header;
    private T payload;
    private byte[] signature;
    private String headerString;
    private String payloadString;

    public static <T extends Serializable> JWS<T> parse(String value, ObjectCodec objectCodec, Class<T> type) {
        JsonConverter jsonConverter = new JsonConverter(objectCodec);
        String[] data = value.split("\\.");
        if (data.length != 3) {
            throw new IllegalArgumentException("JWS value is not divided by two period.");
        }
        String headerString = data[0];
        String payloadString = data[1];
        String signatureString = data[2];
        JWSHeader header = (JWSHeader)jsonConverter.readValue(new String(Base64UrlUtil.decode((String)headerString)), JWSHeader.class);
        Serializable payload = (Serializable)jsonConverter.readValue(new String(Base64UrlUtil.decode((String)payloadString)), type);
        byte[] signature = Base64UrlUtil.decode((String)signatureString);
        return new JWS<Serializable>(header, headerString, payload, payloadString, signature);
    }

    private JWS(JWSHeader header, String headerString, T payload, String payloadString, byte[] signature) {
        this.header = header;
        this.payload = payload;
        this.signature = signature;
        this.headerString = headerString;
        this.payloadString = payloadString;
    }

    public JWSHeader getHeader() {
        return this.header;
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public T getPayload() {
        return this.payload;
    }

    public String getPayloadString() {
        return this.payloadString;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public boolean isValidSignature() {
        String signedData = this.headerString + "." + this.payloadString;
        try {
            Signature signatureObj = SignatureUtil.createSignature((String)this.header.getAlg().getJcaName());
            PublicKey publicKey = this.header.getX5c().getEndEntityAttestationCertificate().getCertificate().getPublicKey();
            signatureObj.initVerify(publicKey);
            signatureObj.update(signedData.getBytes());
            byte[] sig = publicKey instanceof ECPublicKey ? JWSSignatureUtil.convertJWSSignatureToDerSignature(this.signature) : this.signature;
            return signatureObj.verify(sig);
        }
        catch (InvalidKeyException | SignatureException e) {
            this.logger.debug("Signature verification failed", (Throwable)e);
            return false;
        }
    }
}

