/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum TokenBindingStatus {
    PRESENT("present"),
    SUPPORTED("supported"),
    NOT_SUPPORTED("not-supported");

    private final String value;

    private TokenBindingStatus(String value) {
        this.value = value;
    }

    @JsonCreator
    public static TokenBindingStatus create(String value) throws InvalidFormatException {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "present": {
                return PRESENT;
            }
            case "supported": {
                return SUPPORTED;
            }
            case "not-supported": {
                return NOT_SUPPORTED;
            }
        }
        throw new InvalidFormatException(null, "value is out of range", (Object)value, TokenBindingStatus.class);
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

