/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response.attestation.statement;

import com.webauthn4j.response.attestation.statement.TPMUPublicParms;
import com.webauthn4j.util.ArrayUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class TPMSRSAParms
implements TPMUPublicParms {
    private byte[] symmetric;
    private byte[] scheme;
    private byte[] keyBits;
    private byte[] exponent;

    public TPMSRSAParms(byte[] symmetric, byte[] scheme, byte[] keyBits, byte[] exponent) {
        this.symmetric = symmetric;
        this.scheme = scheme;
        this.keyBits = keyBits;
        this.exponent = exponent;
    }

    public byte[] getSymmetric() {
        return ArrayUtil.clone((byte[])this.symmetric);
    }

    public byte[] getScheme() {
        return ArrayUtil.clone((byte[])this.scheme);
    }

    public byte[] getKeyBits() {
        return ArrayUtil.clone((byte[])this.keyBits);
    }

    public byte[] getExponent() {
        return ArrayUtil.clone((byte[])this.exponent);
    }

    @Override
    public byte[] getBytes() {
        return ByteBuffer.allocate(10).put(this.symmetric).put(this.scheme).put(this.keyBits).put(this.exponent).array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMSRSAParms that = (TPMSRSAParms)o;
        return Arrays.equals(this.symmetric, that.symmetric) && Arrays.equals(this.scheme, that.scheme) && Arrays.equals(this.keyBits, that.keyBits) && Arrays.equals(this.exponent, that.exponent);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.symmetric);
        result = 31 * result + Arrays.hashCode(this.scheme);
        result = 31 * result + Arrays.hashCode(this.keyBits);
        result = 31 * result + Arrays.hashCode(this.exponent);
        return result;
    }
}

