/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.UnsignedNumberUtil;

public enum TPMEccCurve {
    TPM_ECC_NONE(0),
    TPM_ECC_NIST_P192(1),
    TPM_ECC_NIST_P224(2),
    TPM_ECC_NIST_P256(3),
    TPM_ECC_NIST_P384(4),
    TPM_ECC_NIST_P521(5),
    TPM_ECC_BN_P256(16),
    TPM_ECC_BN_P638(17),
    TPM_ECC_SM2_P256(32);

    private final int value;

    private TPMEccCurve(int value) {
        this.value = value;
    }

    public byte[] getBytes() {
        return UnsignedNumberUtil.toBytes((int)this.getValue());
    }

    @JsonCreator
    public static TPMEccCurve create(int value) throws InvalidFormatException {
        switch (value) {
            case 0: {
                return TPM_ECC_NONE;
            }
            case 1: {
                return TPM_ECC_NIST_P192;
            }
            case 2: {
                return TPM_ECC_NIST_P224;
            }
            case 3: {
                return TPM_ECC_NIST_P256;
            }
            case 4: {
                return TPM_ECC_NIST_P384;
            }
            case 5: {
                return TPM_ECC_NIST_P521;
            }
            case 16: {
                return TPM_ECC_BN_P256;
            }
            case 17: {
                return TPM_ECC_BN_P638;
            }
            case 32: {
                return TPM_ECC_SM2_P256;
            }
        }
        throw new InvalidFormatException(null, "value is out of range", (Object)value, TPMEccCurve.class);
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

