/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum PublicKeyCredentialType {
    PUBLIC_KEY("public-key");

    private String value;

    private PublicKeyCredentialType(String value) {
        this.value = value;
    }

    public static PublicKeyCredentialType create(String value) {
        if (value == null) {
            return null;
        }
        if ("public-key".equals(value)) {
            return PUBLIC_KEY;
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static PublicKeyCredentialType fromJson(String value) throws InvalidFormatException {
        try {
            return PublicKeyCredentialType.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, PublicKeyCredentialType.class);
        }
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

