/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.AuthenticationExtensionsClientOutputsConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.registry.Registry;
import com.webauthn4j.response.WebAuthnRegistrationContext;
import com.webauthn4j.response.attestation.AttestationObject;
import com.webauthn4j.response.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.response.client.ClientDataType;
import com.webauthn4j.response.client.CollectedClientData;
import com.webauthn4j.response.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.response.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.AttestationValidator;
import com.webauthn4j.validator.BeanAssertUtil;
import com.webauthn4j.validator.ChallengeValidator;
import com.webauthn4j.validator.ExtensionValidator;
import com.webauthn4j.validator.OriginValidator;
import com.webauthn4j.validator.RegistrationObject;
import com.webauthn4j.validator.RpIdHashValidator;
import com.webauthn4j.validator.TokenBindingValidator;
import com.webauthn4j.validator.WebAuthnRegistrationContextValidationResponse;
import com.webauthn4j.validator.attestation.statement.AttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidkey.NullAndroidKeyAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidsafetynet.NullAndroidSafetyNetAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.none.NoneAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.packed.NullPackedAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.u2f.NullFIDOU2FAttestationStatementValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.NullCertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.ecdaa.ECDAATrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.ecdaa.NullECDAATrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.DefaultSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.NullSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.MaliciousDataException;
import com.webauthn4j.validator.exception.UserNotPresentException;
import com.webauthn4j.validator.exception.UserNotVerifiedException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class WebAuthnRegistrationContextValidator {
    private final Registry registry;
    private final CollectedClientDataConverter collectedClientDataConverter;
    private final AttestationObjectConverter attestationObjectConverter;
    private final AuthenticationExtensionsClientOutputsConverter authenticationExtensionsClientOutputsConverter;
    private final ChallengeValidator challengeValidator = new ChallengeValidator();
    private final OriginValidator originValidator = new OriginValidator();
    private final TokenBindingValidator tokenBindingValidator = new TokenBindingValidator();
    private final RpIdHashValidator rpIdHashValidator = new RpIdHashValidator();
    private final ExtensionValidator extensionValidator = new ExtensionValidator();
    private final AttestationValidator attestationValidator;

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, new DefaultSelfAttestationTrustworthinessValidator(), new Registry());
    }

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, selfAttestationTrustworthinessValidator, new Registry());
    }

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, Registry registry) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, new DefaultSelfAttestationTrustworthinessValidator(), registry);
    }

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator, Registry registry) {
        AssertUtil.notNull(attestationStatementValidators, (String)"attestationStatementValidators must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessValidator, (String)"certPathTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)ecdaaTrustworthinessValidator, (String)"ecdaaTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessValidator, (String)"selfAttestationTrustworthinessValidator must not be null");
        this.registry = registry;
        this.collectedClientDataConverter = new CollectedClientDataConverter(registry);
        this.attestationObjectConverter = new AttestationObjectConverter(registry);
        this.authenticationExtensionsClientOutputsConverter = new AuthenticationExtensionsClientOutputsConverter(registry);
        this.attestationValidator = new AttestationValidator(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, selfAttestationTrustworthinessValidator);
    }

    public static WebAuthnRegistrationContextValidator createNonStrictRegistrationContextValidator() {
        return WebAuthnRegistrationContextValidator.createNonStrictRegistrationContextValidator(new Registry());
    }

    public static WebAuthnRegistrationContextValidator createNonStrictRegistrationContextValidator(Registry registry) {
        return new WebAuthnRegistrationContextValidator(Arrays.asList(new NoneAttestationStatementValidator(), new NullFIDOU2FAttestationStatementValidator(), new NullPackedAttestationStatementValidator(), new NullAndroidKeyAttestationStatementValidator(), new NullAndroidSafetyNetAttestationStatementValidator()), new NullCertPathTrustworthinessValidator(), new NullECDAATrustworthinessValidator(), new NullSelfAttestationTrustworthinessValidator(), registry);
    }

    public WebAuthnRegistrationContextValidationResponse validate(WebAuthnRegistrationContext registrationContext) {
        BeanAssertUtil.validate(registrationContext);
        byte[] clientDataBytes = registrationContext.getClientDataJSON();
        byte[] attestationObjectBytes = registrationContext.getAttestationObject();
        CollectedClientData collectedClientData = this.collectedClientDataConverter.convert(clientDataBytes);
        AttestationObject attestationObject = this.attestationObjectConverter.convert(attestationObjectBytes);
        AuthenticationExtensionsClientOutputs authenticationExtensionsClientOutputs = this.authenticationExtensionsClientOutputsConverter.convert(registrationContext.getClientExtensionsJSON());
        BeanAssertUtil.validate(collectedClientData);
        BeanAssertUtil.validate(attestationObject);
        BeanAssertUtil.validateAuthenticationExtensionsClientOutputs(authenticationExtensionsClientOutputs);
        this.validateAuthenticatorDataField(attestationObject.getAuthenticatorData());
        byte[] authenticatorDataBytes = this.attestationObjectConverter.extractAuthenticatorData(attestationObjectBytes);
        RegistrationObject registrationObject = new RegistrationObject(collectedClientData, clientDataBytes, attestationObject, attestationObjectBytes, authenticatorDataBytes, registrationContext.getServerProperty());
        AuthenticatorData authenticatorData = attestationObject.getAuthenticatorData();
        ServerProperty serverProperty = registrationContext.getServerProperty();
        if (!Objects.equals((Object)collectedClientData.getType(), (Object)ClientDataType.CREATE)) {
            throw new MaliciousDataException("Bad client data type");
        }
        this.challengeValidator.validate(collectedClientData, serverProperty);
        this.originValidator.validate(collectedClientData, serverProperty);
        this.tokenBindingValidator.validate(collectedClientData.getTokenBinding(), serverProperty.getTokenBindingId());
        this.rpIdHashValidator.validate(authenticatorData.getRpIdHash(), serverProperty);
        this.validateUVUPFlags(authenticatorData, registrationContext.isUserVerificationRequired(), registrationContext.isUserPresenceRequired());
        AuthenticationExtensionsAuthenticatorOutputs extensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        List expectedExtensionIdentifiers = registrationContext.getExpectedExtensionIds();
        this.extensionValidator.validate(authenticationExtensionsClientOutputs, extensionsAuthenticatorOutputs, expectedExtensionIdentifiers);
        this.attestationValidator.validate(registrationObject);
        return new WebAuthnRegistrationContextValidationResponse(collectedClientData, attestationObject, authenticationExtensionsClientOutputs);
    }

    void validateAuthenticatorDataField(AuthenticatorData authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() == null) {
            throw new MaliciousDataException("attestedCredentialData must not be null on registration");
        }
    }

    void validateUVUPFlags(AuthenticatorData authenticatorData, boolean isUserVerificationRequired, boolean isUserPresenceRequired) {
        if (isUserVerificationRequired && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("User not verified");
        }
        if (isUserPresenceRequired && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("User not present");
        }
    }
}

