/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.response.attestation.AttestationObject;
import com.webauthn4j.response.attestation.authenticator.AAGUID;
import com.webauthn4j.response.attestation.statement.AttestationStatement;
import com.webauthn4j.response.attestation.statement.AttestationType;
import com.webauthn4j.response.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.exception.NotImplementedException;
import com.webauthn4j.validator.RegistrationObject;
import com.webauthn4j.validator.attestation.statement.AttestationStatementValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.ecdaa.ECDAATrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.BadAaguidException;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import java.util.List;
import java.util.Objects;

class AttestationValidator {
    private static final AAGUID U2F_AAGUID = AAGUID.ZERO;
    private final List<AttestationStatementValidator> attestationStatementValidators;
    private final CertPathTrustworthinessValidator certPathTrustworthinessValidator;
    private final ECDAATrustworthinessValidator ecdaaTrustworthinessValidator;
    private final SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator;

    AttestationValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator) {
        this.attestationStatementValidators = attestationStatementValidators;
        this.certPathTrustworthinessValidator = certPathTrustworthinessValidator;
        this.ecdaaTrustworthinessValidator = ecdaaTrustworthinessValidator;
        this.selfAttestationTrustworthinessValidator = selfAttestationTrustworthinessValidator;
    }

    public void validate(RegistrationObject registrationObject) {
        AAGUID aaguid;
        AttestationObject attestationObject = registrationObject.getAttestationObject();
        AttestationType attestationType = this.validateAttestationStatement(registrationObject);
        if (attestationObject.getFormat().equals("fido-u2f") && !Objects.equals(aaguid = attestationObject.getAuthenticatorData().getAttestedCredentialData().getAaguid(), U2F_AAGUID)) {
            throw new BadAaguidException("AAGUID is not 0x00 though it is in U2F attestation.");
        }
        AttestationStatement attestationStatement = attestationObject.getAttestationStatement();
        switch (attestationType) {
            case SELF: {
                if (attestationStatement instanceof CertificateBaseAttestationStatement) {
                    CertificateBaseAttestationStatement certificateBaseAttestationStatement = (CertificateBaseAttestationStatement)attestationStatement;
                    this.selfAttestationTrustworthinessValidator.validate(certificateBaseAttestationStatement);
                    break;
                }
                throw new IllegalStateException();
            }
            case ECDAA: {
                this.ecdaaTrustworthinessValidator.validate(attestationStatement);
                break;
            }
            case BASIC: 
            case ATT_CA: {
                if (attestationStatement instanceof CertificateBaseAttestationStatement) {
                    CertificateBaseAttestationStatement certificateBaseAttestationStatement = (CertificateBaseAttestationStatement)attestationStatement;
                    AAGUID aaguid2 = attestationObject.getAuthenticatorData().getAttestedCredentialData().getAaguid();
                    this.certPathTrustworthinessValidator.validate(aaguid2, certificateBaseAttestationStatement);
                    break;
                }
                throw new IllegalStateException();
            }
            case NONE: {
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
    }

    private AttestationType validateAttestationStatement(RegistrationObject registrationObject) {
        for (AttestationStatementValidator validator : this.attestationStatementValidators) {
            if (!validator.supports(registrationObject)) continue;
            return validator.validate(registrationObject);
        }
        throw new BadAttestationStatementException("Supplied AttestationStatement format is not configured.");
    }
}

