/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.response.attestation.authenticator.AbstractCredentialPublicKey;
import com.webauthn4j.response.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.response.attestation.statement.COSEKeyOperation;
import com.webauthn4j.response.attestation.statement.COSEKeyType;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.RSAUtil;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.List;

public class RSACredentialPublicKey
extends AbstractCredentialPublicKey {
    @JsonProperty(value="-1")
    private byte[] n;
    @JsonProperty(value="-2")
    private byte[] e;

    @JsonCreator
    public RSACredentialPublicKey(@JsonProperty(value="2") byte[] keyId, @JsonProperty(value="3") COSEAlgorithmIdentifier algorithm, @JsonProperty(value="4") List<COSEKeyOperation> keyOpts, @JsonProperty(value="5") byte[] baseIV, @JsonProperty(value="-1") byte[] n, @JsonProperty(value="-2") byte[] e) {
        super(keyId, algorithm, keyOpts, baseIV);
        this.n = n;
        this.e = e;
    }

    public static RSACredentialPublicKey create(RSAPublicKey publicKey) {
        publicKey.getPublicExponent();
        byte[] n = publicKey.getModulus().toByteArray();
        byte[] e = publicKey.getPublicExponent().toByteArray();
        return new RSACredentialPublicKey(null, COSEAlgorithmIdentifier.RS256, null, null, n, e);
    }

    @Override
    public COSEKeyType getKeyType() {
        return COSEKeyType.RSA;
    }

    public byte[] getN() {
        return ArrayUtil.clone((byte[])this.n);
    }

    public byte[] getE() {
        return ArrayUtil.clone((byte[])this.e);
    }

    @Override
    public PublicKey getPublicKey() {
        RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, this.getN()), new BigInteger(1, this.getE()));
        return RSAUtil.createPublicKey((RSAPublicKeySpec)spec);
    }

    @Override
    public void validate() {
        if (this.getAlgorithm() == null) {
            throw new ConstraintViolationException("algorithm must not be null");
        }
        if (this.e == null) {
            throw new ConstraintViolationException("e must not be null");
        }
        if (this.n == null) {
            throw new ConstraintViolationException("n must not be null");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RSACredentialPublicKey that = (RSACredentialPublicKey)o;
        return Arrays.equals(this.n, that.n) && Arrays.equals(this.e, that.e);
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode(this.n);
        result = 31 * result + Arrays.hashCode(this.e);
        return result;
    }
}

