/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.anchor;

import com.webauthn4j.anchor.CachingTrustAnchorProviderBase;
import com.webauthn4j.response.attestation.authenticator.AAGUID;
import com.webauthn4j.util.CertificateUtil;
import java.io.InputStream;
import java.security.cert.TrustAnchor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SampleTrustAnchorProvider
extends CachingTrustAnchorProviderBase {
    private List<String> classPaths = Collections.singletonList("attestation/google/google-root-CA.crt");

    @Override
    protected Map<AAGUID, Set<TrustAnchor>> loadTrustAnchors() {
        HashSet<TrustAnchor> set = new HashSet<TrustAnchor>();
        for (String classPath : this.classPaths) {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(classPath);
            TrustAnchor trustAnchor = new TrustAnchor(CertificateUtil.generateX509Certificate((InputStream)inputStream), null);
            set.add(trustAnchor);
        }
        return Collections.singletonMap(null, set);
    }
}

