/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.packed;

import com.webauthn4j.attestation.authenticator.CredentialPublicKey;
import com.webauthn4j.attestation.statement.AttestationStatement;
import com.webauthn4j.attestation.statement.AttestationType;
import com.webauthn4j.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.attestation.statement.PackedAttestationStatement;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.util.exception.NotImplementedException;
import com.webauthn4j.validator.RegistrationObject;
import com.webauthn4j.validator.attestation.AttestationStatementValidator;
import com.webauthn4j.validator.exception.BadAlgorithmException;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import com.webauthn4j.validator.exception.BadSignatureException;
import com.webauthn4j.validator.exception.UnsupportedAttestationFormatException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;

public class PackedAttestationStatementValidator
implements AttestationStatementValidator {
    @Override
    public AttestationType validate(RegistrationObject registrationObject) {
        if (!this.supports(registrationObject)) {
            throw new UnsupportedAttestationFormatException("Specified format is not supported by " + this.getClass().getName());
        }
        PackedAttestationStatement attestationStatement = (PackedAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        byte[] sig = attestationStatement.getSig();
        COSEAlgorithmIdentifier alg = attestationStatement.getAlg();
        byte[] signedData = this.getSignedData(registrationObject);
        if (attestationStatement.getX5c() != null) {
            if (!this.verifySignature(attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate().getPublicKey(), alg, sig, signedData)) {
                throw new BadSignatureException("Bad signature");
            }
            attestationStatement.getX5c().getEndEntityAttestationCertificate().validate();
            byte[] aaguidInCertificate = attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate().getExtensionValue("1.3.6.1.4.1.45724.1.1.4");
            byte[] aaguid = registrationObject.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getAaGuid();
            if (aaguidInCertificate != null && !Arrays.equals(aaguidInCertificate, aaguid)) {
                throw new BadAttestationStatementException("Bad aaguid");
            }
            return AttestationType.BASIC;
        }
        if (attestationStatement.getEcdaaKeyId() != null) {
            throw new NotImplementedException();
        }
        CredentialPublicKey credentialPublicKey = registrationObject.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getCredentialPublicKey();
        COSEAlgorithmIdentifier credentialPublicKeyAlgorithm = credentialPublicKey.getAlgorithm();
        if (!alg.equals((Object)credentialPublicKeyAlgorithm)) {
            throw new BadAlgorithmException("Algorithm doesn't match");
        }
        if (!this.verifySignature(credentialPublicKey.getPublicKey(), alg, sig, signedData)) {
            throw new BadSignatureException("Bad signature");
        }
        return AttestationType.SELF;
    }

    @Override
    public boolean supports(RegistrationObject registrationObject) {
        AttestationStatement attestationStatement = registrationObject.getAttestationObject().getAttestationStatement();
        return PackedAttestationStatement.class.isAssignableFrom(attestationStatement.getClass());
    }

    private boolean verifySignature(PublicKey publicKey, COSEAlgorithmIdentifier algorithmIdentifier, byte[] signature, byte[] data) {
        try {
            Signature verifier = Signature.getInstance(algorithmIdentifier.getName());
            verifier.initVerify(publicKey);
            verifier.update(data);
            return verifier.verify(signature);
        }
        catch (RuntimeException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return false;
        }
    }

    private byte[] getSignedData(RegistrationObject registrationObject) {
        MessageDigest messageDigest = MessageDigestUtil.createSHA256();
        byte[] authenticatorData = registrationObject.getAuthenticatorDataBytes();
        byte[] clientDataHash = messageDigest.digest(registrationObject.getCollectedClientDataBytes());
        return ByteBuffer.allocate(authenticatorData.length + clientDataHash.length).put(authenticatorData).put(clientDataHash).array();
    }
}

